/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.ReadStream;
import java.util.List;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.mongo.MongoClient.class)
public class MongoClient {
    public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg(obj -> new MongoClient((io.vertx.ext.mongo.MongoClient)obj), MongoClient::getDelegate);
    private final io.vertx.ext.mongo.MongoClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClient that = (MongoClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.mongo.MongoClient getDelegate() {
        return this.delegate;
    }

    public static MongoClient createNonShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createNonShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config, String dataSourceName) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)dataSourceName));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public MongoClient save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.save(collection, document, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<String> saveObservable(String collection, JsonObject document) {
        ObservableFuture<String> resultHandler = RxHelper.observableFuture();
        this.save(collection, document, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<String> rxSave(String collection, JsonObject document) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.save(collection, document, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.saveWithOptions(collection, document, writeOption, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<String> saveWithOptionsObservable(String collection, JsonObject document, WriteOption writeOption) {
        ObservableFuture<String> resultHandler = RxHelper.observableFuture();
        this.saveWithOptions(collection, document, writeOption, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.saveWithOptions(collection, document, writeOption, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insert(collection, document, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<String> insertObservable(String collection, JsonObject document) {
        ObservableFuture<String> resultHandler = RxHelper.observableFuture();
        this.insert(collection, document, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<String> rxInsert(String collection, JsonObject document) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.insert(collection, document, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insertWithOptions(collection, document, writeOption, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<String> insertWithOptionsObservable(String collection, JsonObject document, WriteOption writeOption) {
        ObservableFuture<String> resultHandler = RxHelper.observableFuture();
        this.insertWithOptions(collection, document, writeOption, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.insertWithOptions(collection, document, writeOption, (Handler<AsyncResult<String>>)fut)));
    }

    @Deprecated
    public MongoClient update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.update(collection, query, update, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> updateObservable(String collection, JsonObject query, JsonObject update) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.update(collection, query, update, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxUpdate(String collection, JsonObject query, JsonObject update) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.update(collection, query, update, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollection(collection, query, update, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientUpdateResult> updateCollectionObservable(String collection, JsonObject query, JsonObject update) {
        ObservableFuture<MongoClientUpdateResult> resultHandler = RxHelper.observableFuture();
        this.updateCollection(collection, query, update, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateCollection(collection, query, update, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    @Deprecated
    public MongoClient updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.updateWithOptions(collection, query, update, options, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> updateWithOptionsObservable(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.updateWithOptions(collection, query, update, options, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxUpdateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateWithOptions(collection, query, update, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientUpdateResult> updateCollectionWithOptionsObservable(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        ObservableFuture<MongoClientUpdateResult> resultHandler = RxHelper.observableFuture();
        this.updateCollectionWithOptions(collection, query, update, options, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateCollectionWithOptions(collection, query, update, options, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    @Deprecated
    public MongoClient replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.replace(collection, query, replace, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> replaceObservable(String collection, JsonObject query, JsonObject replace) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.replace(collection, query, replace, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxReplace(String collection, JsonObject query, JsonObject replace) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replace(collection, query, replace, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocuments(collection, query, replace, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientUpdateResult> replaceDocumentsObservable(String collection, JsonObject query, JsonObject replace) {
        ObservableFuture<MongoClientUpdateResult> resultHandler = RxHelper.observableFuture();
        this.replaceDocuments(collection, query, replace, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replaceDocuments(collection, query, replace, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    @Deprecated
    public MongoClient replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.replaceWithOptions(collection, query, replace, options, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> replaceWithOptionsObservable(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.replaceWithOptions(collection, query, replace, options, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxReplaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replaceWithOptions(collection, query, replace, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientUpdateResult> replaceDocumentsWithOptionsObservable(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        ObservableFuture<MongoClientUpdateResult> resultHandler = RxHelper.observableFuture();
        this.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replaceDocumentsWithOptions(collection, query, replace, options, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWrite(collection, operations, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientBulkWriteResult> bulkWriteObservable(String collection, List<BulkOperation> operations) {
        ObservableFuture<MongoClientBulkWriteResult> resultHandler = RxHelper.observableFuture();
        this.bulkWrite(collection, operations, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bulkWrite(collection, operations, (Handler<AsyncResult<MongoClientBulkWriteResult>>)fut)));
    }

    public MongoClient bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientBulkWriteResult> bulkWriteWithOptionsObservable(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        ObservableFuture<MongoClientBulkWriteResult> resultHandler = RxHelper.observableFuture();
        this.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bulkWriteWithOptions(collection, operations, bulkWriteOptions, (Handler<AsyncResult<MongoClientBulkWriteResult>>)fut)));
    }

    public MongoClient find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.find(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<List<JsonObject>> findObservable(String collection, JsonObject query) {
        ObservableFuture<List<JsonObject>> resultHandler = RxHelper.observableFuture();
        this.find(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<List<JsonObject>> rxFind(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.find(collection, query, (Handler<AsyncResult<List<JsonObject>>>)fut)));
    }

    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatch(collection, query), TypeArg.unknown());
        return ret;
    }

    public MongoClient findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.findWithOptions(collection, query, options, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<List<JsonObject>> findWithOptionsObservable(String collection, JsonObject query, FindOptions options) {
        ObservableFuture<List<JsonObject>> resultHandler = RxHelper.observableFuture();
        this.findWithOptions(collection, query, options, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findWithOptions(collection, query, options, (Handler<AsyncResult<List<JsonObject>>>)fut)));
    }

    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
        return ret;
    }

    public MongoClient findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOne(collection, query, fields, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneObservable(String collection, JsonObject query, JsonObject fields) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOne(collection, query, fields, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOne(collection, query, fields, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdate(collection, query, update, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneAndUpdateObservable(String collection, JsonObject query, JsonObject update) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOneAndUpdate(collection, query, update, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndUpdate(collection, query, update, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneAndUpdateWithOptionsObservable(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplace(collection, query, replace, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneAndReplaceObservable(String collection, JsonObject query, JsonObject replace) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOneAndReplace(collection, query, replace, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndReplace(collection, query, replace, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneAndReplaceWithOptionsObservable(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDelete(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneAndDeleteObservable(String collection, JsonObject query) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOneAndDelete(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndDelete(collection, query, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> findOneAndDeleteWithOptionsObservable(String collection, JsonObject query, FindOptions findOptions) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndDeleteWithOptions(collection, query, findOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.count(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Long> countObservable(String collection, JsonObject query) {
        ObservableFuture<Long> resultHandler = RxHelper.observableFuture();
        this.count(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Long> rxCount(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.count(collection, query, (Handler<AsyncResult<Long>>)fut)));
    }

    @Deprecated
    public MongoClient remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.remove(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> removeObservable(String collection, JsonObject query) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.remove(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxRemove(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.remove(collection, query, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocuments(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientDeleteResult> removeDocumentsObservable(String collection, JsonObject query) {
        ObservableFuture<MongoClientDeleteResult> resultHandler = RxHelper.observableFuture();
        this.removeDocuments(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocuments(collection, query, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    @Deprecated
    public MongoClient removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.removeWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> removeWithOptionsObservable(String collection, JsonObject query, WriteOption writeOption) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.removeWithOptions(collection, query, writeOption, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxRemoveWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeWithOptions(collection, query, writeOption, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientDeleteResult> removeDocumentsWithOptionsObservable(String collection, JsonObject query, WriteOption writeOption) {
        ObservableFuture<MongoClientDeleteResult> resultHandler = RxHelper.observableFuture();
        this.removeDocumentsWithOptions(collection, query, writeOption, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocumentsWithOptions(collection, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    @Deprecated
    public MongoClient removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.removeOne(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> removeOneObservable(String collection, JsonObject query) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.removeOne(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxRemoveOne(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeOne(collection, query, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocument(collection, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientDeleteResult> removeDocumentObservable(String collection, JsonObject query) {
        ObservableFuture<MongoClientDeleteResult> resultHandler = RxHelper.observableFuture();
        this.removeDocument(collection, query, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocument(collection, query, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    @Deprecated
    public MongoClient removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.removeOneWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> removeOneWithOptionsObservable(String collection, JsonObject query, WriteOption writeOption) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.removeOneWithOptions(collection, query, writeOption, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxRemoveOneWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeOneWithOptions(collection, query, writeOption, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<MongoClientDeleteResult> removeDocumentWithOptionsObservable(String collection, JsonObject query, WriteOption writeOption) {
        ObservableFuture<MongoClientDeleteResult> resultHandler = RxHelper.observableFuture();
        this.removeDocumentWithOptions(collection, query, writeOption, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocumentWithOptions(collection, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createCollection(collectionName, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> createCollectionObservable(String collectionName) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.createCollection(collectionName, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxCreateCollection(String collectionName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createCollection(collectionName, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.getCollections(resultHandler);
        return this;
    }

    @Deprecated
    public Observable<List<String>> getCollectionsObservable() {
        ObservableFuture<List<String>> resultHandler = RxHelper.observableFuture();
        this.getCollections(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<List<String>> rxGetCollections() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getCollections((Handler<AsyncResult<List<String>>>)fut)));
    }

    public MongoClient dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropCollection(collection, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> dropCollectionObservable(String collection) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.dropCollection(collection, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxDropCollection(String collection) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.dropCollection(collection, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndex(collection, key, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> createIndexObservable(String collection, JsonObject key) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.createIndex(collection, key, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxCreateIndex(String collection, JsonObject key) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createIndex(collection, key, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndexWithOptions(collection, key, options, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> createIndexWithOptionsObservable(String collection, JsonObject key, IndexOptions options) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.createIndexWithOptions(collection, key, options, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createIndexWithOptions(collection, key, options, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.listIndexes(collection, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> listIndexesObservable(String collection) {
        ObservableFuture<JsonArray> resultHandler = RxHelper.observableFuture();
        this.listIndexes(collection, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonArray> rxListIndexes(String collection) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listIndexes(collection, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropIndex(collection, indexName, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> dropIndexObservable(String collection, String indexName) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.dropIndex(collection, indexName, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxDropIndex(String collection, String indexName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.dropIndex(collection, indexName, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.runCommand(commandName, command, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonObject> runCommandObservable(String commandName, JsonObject command) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.runCommand(commandName, command, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxRunCommand(String commandName, JsonObject command) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.runCommand(commandName, command, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinct(collection, fieldName, resultClassname, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> distinctObservable(String collection, String fieldName, String resultClassname) {
        ObservableFuture<JsonArray> resultHandler = RxHelper.observableFuture();
        this.distinct(collection, fieldName, resultClassname, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.distinct(collection, fieldName, resultClassname, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
        return this;
    }

    @Deprecated
    public Observable<JsonArray> distinctWithQueryObservable(String collection, String fieldName, String resultClassname, JsonObject query) {
        ObservableFuture<JsonArray> resultHandler = RxHelper.observableFuture();
        this.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.distinctWithQuery(collection, fieldName, resultClassname, query, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregate(collection, pipeline), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
        return arg != null ? new MongoClient(arg) : null;
    }
}

