/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.mqtt.messages.MqttPublishMessage;
import io.vertx.rxjava.mqtt.messages.MqttSubscribeMessage;
import io.vertx.rxjava.mqtt.messages.MqttUnsubscribeMessage;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.mqtt.MqttEndpoint.class)
public class MqttEndpoint {
    public static final TypeArg<MqttEndpoint> __TYPE_ARG = new TypeArg(obj -> new MqttEndpoint((io.vertx.mqtt.MqttEndpoint)obj), MqttEndpoint::getDelegate);
    private final io.vertx.mqtt.MqttEndpoint delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private String cached_2;
    private MqttAuth cached_3;
    private MqttWill cached_4;
    private Integer cached_5;
    private String cached_6;
    private Boolean cached_7;
    private Integer cached_8;
    private Integer cached_9;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttEndpoint that = (MqttEndpoint)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MqttEndpoint(io.vertx.mqtt.MqttEndpoint delegate) {
        this.delegate = delegate;
    }

    public io.vertx.mqtt.MqttEndpoint getDelegate() {
        return this.delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String clientIdentifier() {
        String ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.clientIdentifier();
        return ret;
    }

    public MqttAuth auth() {
        MqttAuth ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = this.delegate.auth();
        return ret;
    }

    public MqttWill will() {
        MqttWill ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = this.delegate.will();
        return ret;
    }

    public int protocolVersion() {
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        int ret = this.delegate.protocolVersion();
        this.cached_5 = ret;
        return ret;
    }

    public String protocolName() {
        String ret;
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        this.cached_6 = ret = this.delegate.protocolName();
        return ret;
    }

    public boolean isCleanSession() {
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        boolean ret = this.delegate.isCleanSession();
        this.cached_7 = ret;
        return ret;
    }

    public int keepAliveTimeSeconds() {
        if (this.cached_8 != null) {
            return this.cached_8;
        }
        int ret = this.delegate.keepAliveTimeSeconds();
        this.cached_8 = ret;
        return ret;
    }

    public int lastMessageId() {
        if (this.cached_9 != null) {
            return this.cached_9;
        }
        int ret = this.delegate.lastMessageId();
        this.cached_9 = ret;
        return ret;
    }

    public void subscriptionAutoAck(boolean isSubscriptionAutoAck) {
        this.delegate.subscriptionAutoAck(isSubscriptionAutoAck);
    }

    public boolean isSubscriptionAutoAck() {
        boolean ret = this.delegate.isSubscriptionAutoAck();
        return ret;
    }

    public MqttEndpoint publishAutoAck(boolean isPublishAutoAck) {
        this.delegate.publishAutoAck(isPublishAutoAck);
        return this;
    }

    public boolean isPublishAutoAck() {
        boolean ret = this.delegate.isPublishAutoAck();
        return ret;
    }

    public MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) {
        this.delegate.autoKeepAlive(isAutoKeepAlive);
        return this;
    }

    public boolean isAutoKeepAlive() {
        boolean ret = this.delegate.isAutoKeepAlive();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public MqttEndpoint setClientIdentifier(String clientIdentifier) {
        this.delegate.setClientIdentifier(clientIdentifier);
        return this;
    }

    public MqttEndpoint disconnectHandler(Handler<Void> handler) {
        this.delegate.disconnectHandler(handler);
        return this;
    }

    public MqttEndpoint subscribeHandler(final Handler<MqttSubscribeMessage> handler) {
        this.delegate.subscribeHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttSubscribeMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttSubscribeMessage event) {
                handler.handle((Object)MqttSubscribeMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttEndpoint unsubscribeHandler(final Handler<MqttUnsubscribeMessage> handler) {
        this.delegate.unsubscribeHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttUnsubscribeMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttUnsubscribeMessage event) {
                handler.handle((Object)MqttUnsubscribeMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttEndpoint publishHandler(final Handler<MqttPublishMessage> handler) {
        this.delegate.publishHandler((Handler)new Handler<io.vertx.mqtt.messages.MqttPublishMessage>(){

            public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
                handler.handle((Object)MqttPublishMessage.newInstance(event));
            }
        });
        return this;
    }

    public MqttEndpoint publishAcknowledgeHandler(Handler<Integer> handler) {
        this.delegate.publishAcknowledgeHandler(handler);
        return this;
    }

    public MqttEndpoint publishReceivedHandler(Handler<Integer> handler) {
        this.delegate.publishReceivedHandler(handler);
        return this;
    }

    public MqttEndpoint publishReleaseHandler(Handler<Integer> handler) {
        this.delegate.publishReleaseHandler(handler);
        return this;
    }

    public MqttEndpoint publishCompletionHandler(Handler<Integer> handler) {
        this.delegate.publishCompletionHandler(handler);
        return this;
    }

    public MqttEndpoint pingHandler(Handler<Void> handler) {
        this.delegate.pingHandler(handler);
        return this;
    }

    public MqttEndpoint closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public MqttEndpoint exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttEndpoint accept() {
        this.delegate.accept();
        return this;
    }

    public MqttEndpoint accept(boolean sessionPresent) {
        this.delegate.accept(sessionPresent);
        return this;
    }

    public MqttEndpoint reject(MqttConnectReturnCode returnCode) {
        this.delegate.reject(returnCode);
        return this;
    }

    public MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<MqttQoS> grantedQoSLevels) {
        this.delegate.subscribeAcknowledge(subscribeMessageId, grantedQoSLevels);
        return this;
    }

    public MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId) {
        this.delegate.unsubscribeAcknowledge(unsubscribeMessageId);
        return this;
    }

    public MqttEndpoint publishAcknowledge(int publishMessageId) {
        this.delegate.publishAcknowledge(publishMessageId);
        return this;
    }

    public MqttEndpoint publishReceived(int publishMessageId) {
        this.delegate.publishReceived(publishMessageId);
        return this;
    }

    public MqttEndpoint publishRelease(int publishMessageId) {
        this.delegate.publishRelease(publishMessageId);
        return this;
    }

    public MqttEndpoint publishComplete(int publishMessageId) {
        this.delegate.publishComplete(publishMessageId);
        return this;
    }

    public MqttEndpoint publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain);
        return this;
    }

    public MqttEndpoint publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
        return this;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.publish(topic, payload, qosLevel, isDup, isRetain, (Handler<AsyncResult<Integer>>)fut)));
    }

    public MqttEndpoint pong() {
        this.delegate.pong();
        return this;
    }

    public static MqttEndpoint newInstance(io.vertx.mqtt.MqttEndpoint arg) {
        return arg != null ? new MqttEndpoint(arg) : null;
    }
}

