/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Consumer;

public class BinaryEncoder
implements Consumer<int[]> {
    private volatile Charset charset;
    final Consumer<byte[]> onByte;

    public BinaryEncoder(Charset charset, Consumer<byte[]> onByte) {
        this.charset = charset;
        this.onByte = onByte;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void accept(int[] codePoints) {
        char[] tmp = new char[2];
        int capacity = 0;
        for (int codePoint : codePoints) {
            capacity += Character.charCount(codePoint);
        }
        CharBuffer charBuf = CharBuffer.allocate(capacity);
        for (int codePoint : codePoints) {
            int size = Character.toChars(codePoint, tmp, 0);
            charBuf.put(tmp, 0, size);
        }
        charBuf.flip();
        ByteBuffer bytesBuf = this.charset.encode(charBuf);
        byte[] bytes = bytesBuf.array();
        if (bytesBuf.limit() < bytesBuf.array().length) {
            bytes = Arrays.copyOf(bytes, bytesBuf.limit());
        }
        this.onByte.accept(bytes);
    }
}

