/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.pty;

import io.termd.core.pty.PtyMaster;
import io.termd.core.readline.Function;
import io.termd.core.readline.Keymap;
import io.termd.core.readline.Readline;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.util.Helper;
import java.io.InputStream;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtyBridge {
    Logger log = LoggerFactory.getLogger(TtyBridge.class);
    final TtyConnection conn;
    private Consumer<PtyMaster> processListener;
    private Consumer<int[]> processStdoutListener;
    private Consumer<String> processStdinListener;

    public TtyBridge(TtyConnection conn) {
        this.conn = conn;
    }

    public Consumer<PtyMaster> getProcessListener() {
        return this.processListener;
    }

    public TtyBridge setProcessListener(Consumer<PtyMaster> processListener) {
        this.processListener = processListener;
        return this;
    }

    public Consumer<String> getProcessStdinListener() {
        return this.processStdinListener;
    }

    public TtyBridge setProcessStdinListener(Consumer<String> processStdinListener) {
        this.processStdinListener = processStdinListener;
        return this;
    }

    public Consumer<int[]> getProcessStdoutListener() {
        return this.processStdoutListener;
    }

    public TtyBridge setProcessStdoutListener(Consumer<int[]> processStdoutListener) {
        this.processStdoutListener = processStdoutListener;
        return this;
    }

    public TtyBridge readline() {
        InputStream inputrc = Keymap.class.getResourceAsStream("inputrc");
        Keymap keymap = new Keymap(inputrc);
        Readline readline = new Readline(keymap);
        for (Function function : Helper.loadServices(Thread.currentThread().getContextClassLoader(), Function.class)) {
            this.log.trace("Server is adding function to readline: {}", (Object)function);
            readline.addFunction(function);
        }
        this.conn.setTerminalTypeHandler(term -> {});
        this.conn.stdoutHandler().accept(Helper.toCodePoints("Welcome sir\n"));
        this.read(this.conn, readline);
        return this;
    }

    void read(TtyConnection conn, Readline readline) {
        readline.readline(conn, "% ", line -> this.onNewLine(conn, readline, (String)line));
    }

    private void onNewLine(TtyConnection conn, Readline readline, String line) {
        if (this.processStdinListener != null) {
            this.processStdinListener.accept(line);
        }
        if (line == null) {
            conn.close();
            return;
        }
        PtyMaster task = new PtyMaster(line, buffer -> this.onStdOut(conn, (int[])buffer), empty -> this.doneHandler(conn, readline));
        conn.setEventHandler((event, cp) -> {
            if (event == TtyEvent.INTR) {
                task.interruptProcess();
            }
        });
        if (this.processListener != null) {
            this.processListener.accept(task);
        }
        task.start();
    }

    private void doneHandler(TtyConnection conn, Readline readline) {
        conn.setEventHandler(null);
        conn.execute(() -> this.read(conn, readline));
    }

    private void onStdOut(TtyConnection conn, int[] buffer) {
        conn.execute(() -> conn.stdoutHandler().accept(buffer));
        if (this.processStdoutListener != null) {
            this.processStdoutListener.accept(buffer);
        }
    }
}

