/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.readline.KeyEvent;
import io.termd.core.readline.Keymap;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class EventQueue
implements Iterator<KeyEvent> {
    private KeyEvent[] bindings;
    private final LinkedList<KeyEvent> events = new LinkedList();
    private int[] pending = new int[0];

    public EventQueue(Keymap keymap) {
        this.bindings = keymap.bindings.toArray(new KeyEvent[keymap.bindings.size()]);
    }

    public EventQueue append(int ... codePoints) {
        this.pending = Arrays.copyOf(this.pending, this.pending.length + codePoints.length);
        System.arraycopy(codePoints, 0, this.pending, this.pending.length - codePoints.length, codePoints.length);
        return this;
    }

    public EventQueue append(KeyEvent event) {
        this.events.add(event);
        return this;
    }

    public KeyEvent peek() {
        if (this.events.isEmpty()) {
            return this.match(this.pending);
        }
        return this.events.peekFirst();
    }

    @Override
    public boolean hasNext() {
        return this.peek() != null;
    }

    @Override
    public KeyEvent next() {
        KeyEvent next;
        if (this.events.isEmpty() && (next = this.match(this.pending)) != null) {
            this.events.add(next);
            this.pending = Arrays.copyOfRange(this.pending, next.length(), this.pending.length);
        }
        return this.events.removeFirst();
    }

    public int[] clear() {
        this.events.clear();
        int[] buffer = this.pending;
        this.pending = new int[0];
        return buffer;
    }

    public IntBuffer getBuffer() {
        return IntBuffer.wrap(this.pending).asReadOnlyBuffer();
    }

    private KeyEvent match(int[] buffer) {
        if (buffer.length > 0) {
            KeyEvent candidate = null;
            int prefixes = 0;
            block0: for (KeyEvent action : this.bindings) {
                int i;
                if (action.length() <= 0) continue;
                if (action.length() <= buffer.length) {
                    for (i = 0; i < action.length(); ++i) {
                        if (action.getCodePointAt(i) != buffer[i]) continue block0;
                    }
                    if (candidate != null && candidate.length() > action.length()) continue;
                    candidate = action;
                    continue;
                }
                for (i = 0; i < buffer.length; ++i) {
                    if (action.getCodePointAt(i) != buffer[i]) continue block0;
                }
                ++prefixes;
            }
            if (candidate == null) {
                if (prefixes == 0) {
                    final int c = buffer[0];
                    return new KeyEvent(){

                        @Override
                        public int getCodePointAt(int index) throws IndexOutOfBoundsException {
                            if (index != 0) {
                                throw new IndexOutOfBoundsException("Wrong index " + index);
                            }
                            return c;
                        }

                        @Override
                        public int length() {
                            return 1;
                        }

                        public String toString() {
                            return "key:" + c;
                        }
                    };
                }
            } else {
                return candidate;
            }
        }
        return null;
    }
}

