/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.readline.Keymap;
import io.termd.core.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class InputrcParser {
    static final Pattern COMMENT = Pattern.compile("#.*");
    static final Pattern CONDITIONAL = Pattern.compile("\\$.*");
    static final Pattern SET_VARIABLE = Pattern.compile("set\\s+(\\S)+\\s+(\\S)+\\s*");
    static final Pattern BIND = Pattern.compile("(?:(?:\"(.*)\")|(.*)):\\s*(?:(?:\"(.*)\")|(?:'(.*)')|(\\S+))\\s*");
    static final Pattern A = Pattern.compile("^\\\\([0-9]{1,3})");
    static final Pattern B = Pattern.compile("^\\\\x([0-9,A-F,a-f]{1,2})");

    static void parse(String s, InputrcParser handler) throws UnsupportedEncodingException {
        InputrcParser.parse(new ByteArrayInputStream(s.getBytes("US-ASCII")), handler);
    }

    static void parse(InputStream s, InputrcParser handler) {
        Scanner sc = new Scanner(s, "US-ASCII").useDelimiter("\n");
        while (sc.hasNext()) {
            String next = sc.next();
            if (COMMENT.matcher(next).matches()) continue;
            if (CONDITIONAL.matcher(next).matches()) {
                Logging.READLINE.log(Level.WARNING, "Inputrc conditional not implemented");
                continue;
            }
            Matcher matcher = SET_VARIABLE.matcher(next);
            if (matcher.matches()) {
                String variable = matcher.group(1);
                String value = matcher.group(2);
                Logging.READLINE.log(Level.WARNING, "Inputrc set variable not implemented");
                continue;
            }
            matcher = BIND.matcher(next);
            if (!matcher.matches()) continue;
            String keyseq = matcher.group(1);
            String keyname = matcher.group(2);
            String macro1 = matcher.group(3);
            String macro2 = matcher.group(4);
            String functionname = matcher.group(5);
            if (keyseq != null) {
                int[] f = InputrcParser.parseKeySeq(keyseq);
                if (functionname != null) {
                    handler.bindFunction(f, functionname);
                    continue;
                }
                if (macro1 != null) {
                    handler.bindMacro(f, macro1);
                    continue;
                }
                handler.bindMacro(f, macro2);
                continue;
            }
            if (functionname != null) {
                handler.bindFunction(keyname, functionname);
                continue;
            }
            if (macro1 != null) {
                handler.bindMacro(keyname, macro1);
                continue;
            }
            handler.bindMacro(keyname, macro2);
        }
    }

    void bindMacro(String keyName, String macro) {
    }

    void bindFunction(String keyName, String functionName) {
    }

    void bindMacro(int[] keySequence, String macro) {
    }

    void bindFunction(int[] keySequence, String functionName) {
    }

    public static Keymap create() {
        InputStream inputrc = InputrcParser.class.getResourceAsStream("inputrc");
        return new Keymap(inputrc);
    }

    static int[] parseKeySeq(String keyseq) {
        ArrayList<Integer> builder = new ArrayList<Integer>();
        while (keyseq.length() > 0) {
            if (keyseq.startsWith("\\C-") && keyseq.length() > 3) {
                int c = Character.toUpperCase(keyseq.charAt(3)) - 64 & 0x7F;
                builder.add(c);
                keyseq = keyseq.substring(4);
                continue;
            }
            if (keyseq.startsWith("\\M-") && keyseq.length() > 3) {
                int c = Character.toUpperCase(keyseq.charAt(3)) - 64 & 0x7F;
                builder.add(27);
                builder.add(c);
                keyseq = keyseq.substring(4);
                continue;
            }
            if (keyseq.startsWith("\\e")) {
                builder.add(27);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\\\")) {
                builder.add(92);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\\"")) {
                builder.add(34);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\'")) {
                builder.add(39);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\a")) {
                builder.add(7);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\b")) {
                builder.add(8);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\d")) {
                builder.add(127);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\f")) {
                builder.add(12);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\n")) {
                builder.add(10);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\r")) {
                builder.add(13);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\t")) {
                builder.add(9);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\v")) {
                builder.add(11);
                keyseq = keyseq.substring(2);
                continue;
            }
            Matcher matcher = A.matcher(keyseq);
            if (matcher.find()) {
                builder.add(Integer.parseInt(matcher.group(1), 8));
                keyseq = keyseq.substring(matcher.end());
                continue;
            }
            matcher = B.matcher(keyseq);
            if (matcher.find()) {
                builder.add(Integer.parseInt(matcher.group(1), 16));
                keyseq = keyseq.substring(matcher.end());
                continue;
            }
            builder.add(Integer.valueOf(keyseq.charAt(0)));
            keyseq = keyseq.substring(1);
        }
        int[] f = new int[builder.size()];
        for (int i = 0; i < builder.size(); ++i) {
            f[i] = (Integer)builder.get(i);
        }
        return f;
    }
}

