/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.Capability;
import io.termd.core.term.Sequence;

public class Feature<T> {
    final Capability<T> capability;
    final T value;

    public static <T> Feature<T> create(String name, T value) {
        Capability<Object> cap = null;
        if (value instanceof Boolean) {
            cap = Capability.getCapability(name, Boolean.class);
        } else if (value instanceof Integer) {
            cap = Capability.getCapability(name, Integer.class);
        } else if (value instanceof Sequence) {
            cap = Capability.getCapability(name, Sequence.class);
        }
        if (cap == null) {
            cap = new Capability(value.getClass(), null, name, null, null);
        }
        return new Feature<Boolean>(cap, (Boolean)value);
    }

    public Feature(Capability<T> capability, T value) {
        this.capability = capability;
        this.value = value;
    }

    public Feature(String name, T value) {
        this.capability = new Capability(value.getClass(), name, name, null, null);
        this.value = value;
    }

    public T value() {
        return this.value;
    }

    public Capability<T> capability() {
        return this.capability;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Feature) {
            Feature that = (Feature)obj;
            return this.capability.equals(that.capability) && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        if (this.value instanceof Boolean) {
            Boolean booleanValue = (Boolean)this.value;
            return booleanValue != false ? this.capability.name : this.capability.name + "@";
        }
        if (this.value instanceof Integer) {
            return this.capability.name + "#" + this.value;
        }
        return this.capability.name + "=" + this.value;
    }
}

