/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.tty;

import io.termd.core.tty.TtyEvent;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class TtyEventDecoder
implements Consumer<int[]> {
    private Consumer<int[]> readHandler;
    private BiConsumer<TtyEvent, Integer> eventHandler;
    private final int vintr;
    private final int veof;
    private final int vsusp;

    public TtyEventDecoder(int vintr, int vsusp, int veof) {
        this.vintr = vintr;
        this.vsusp = vsusp;
        this.veof = veof;
    }

    public Consumer<int[]> getReadHandler() {
        return this.readHandler;
    }

    public TtyEventDecoder setReadHandler(Consumer<int[]> readHandler) {
        this.readHandler = readHandler;
        return this;
    }

    public BiConsumer<TtyEvent, Integer> getEventHandler() {
        return this.eventHandler;
    }

    public TtyEventDecoder setEventHandler(BiConsumer<TtyEvent, Integer> eventHandler) {
        this.eventHandler = eventHandler;
        return this;
    }

    @Override
    public void accept(int[] data) {
        if (this.eventHandler != null) {
            int index = 0;
            while (index < data.length) {
                int val = data[index];
                TtyEvent event = null;
                if (val == this.vintr) {
                    event = TtyEvent.INTR;
                } else if (val == this.vsusp) {
                    event = TtyEvent.SUSP;
                } else if (val == this.veof) {
                    event = TtyEvent.EOF;
                }
                if (event != null && this.eventHandler != null) {
                    int[] a;
                    if (this.readHandler != null) {
                        a = new int[index];
                        if (index > 0) {
                            System.arraycopy(data, 0, a, 0, index);
                            this.readHandler.accept(a);
                        }
                    }
                    this.eventHandler.accept(event, val);
                    a = new int[data.length - index - 1];
                    System.arraycopy(data, index + 1, a, 0, a.length);
                    data = a;
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        if (this.readHandler != null && data.length > 0) {
            this.readHandler.accept(data);
        }
    }
}

