/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.IMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastServerID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class HazelcastAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final IMap<K, V> map;

    public HazelcastAsyncMap(Vertx vertx, IMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
    }

    public void get(K k, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.get(kk))), resultHandler);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> {
            this.map.set(kk, HazelcastServerID.convertServerID(vv));
            fut.complete();
        }, completionHandler);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv)))), resultHandler);
    }

    public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> {
            this.map.set(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS);
            fut.complete();
        }, completionHandler);
    }

    public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS))), resultHandler);
    }

    public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.remove(kk))), resultHandler);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.remove(kk, vv)), resultHandler);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.replace(kk, vv))), resultHandler);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(oldValue);
        V vvv = ConversionUtils.convertParam(newValue);
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.replace(kk, vv, vvv)), resultHandler);
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            this.map.clear();
            fut.complete();
        }, resultHandler);
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.size()), resultHandler);
    }

    public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            HashSet set = new HashSet();
            for (Object kk : this.map.keySet()) {
                Object k = ConversionUtils.convertReturn(kk);
                set.add(k);
            }
            fut.complete(set);
        }, resultHandler);
    }

    public void values(Handler<AsyncResult<List<V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            ArrayList list = new ArrayList();
            for (Object vv : this.map.values()) {
                Object v = ConversionUtils.convertReturn(vv);
                list.add(v);
            }
            fut.complete(list);
        }, resultHandler);
    }

    public void entries(Handler<AsyncResult<Map<K, V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.map.entrySet()) {
                Object k = ConversionUtils.convertReturn(entry.getKey());
                Object v = ConversionUtils.convertReturn(entry.getValue());
                result.put(k, v);
            }
            fut.complete(result);
        }, resultHandler);
    }
}

