/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl.shell;

import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.MetricsService;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;

@Name(value="metrics-info")
@Summary(value="Show metrics info for the current Vert.x instance in Json format")
public class MetricsInfo
extends AnnotatedCommand {
    private String name;

    @Argument(index=0, argName="name")
    @Description(value="the metrics name, can be a metrics prefix or a precise name")
    public void setName(String name) {
        this.name = name;
    }

    public void process(CommandProcess process) {
        String name = (String)process.args().get(0);
        MetricsService metrics = MetricsService.create(process.vertx());
        JsonObject snapshot = metrics.getMetricsSnapshot(name);
        process.write(snapshot.encodePrettily() + "\n");
        process.end();
    }
}

