/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.util;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.SSLConfiguration;
import com.github.mauricio.async.db.SSLConfiguration$;
import com.github.mauricio.async.db.exceptions.UnableToParseURLException;
import com.github.mauricio.async.db.util.AbstractURIParser$;
import io.netty.buffer.ByteBufAllocator;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0003\u0003y!!E!cgR\u0014\u0018m\u0019;V%&\u0003\u0016M]:fe*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005\u0011AM\u0019\u0006\u0003\u000f!\tQ!Y:z]\u000eT!!\u0003\u0006\u0002\u00115\fWO]5dS>T!a\u0003\u0007\u0002\r\u001dLG\u000f[;c\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\b9\u0001\u0011\r\u0011\"\u0005\u001e\u0003\u0019awnZ4feV\ta\u0004\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f\u001c45U*\t1%A\u0002pe\u001eL!!\n\u0011\u0003\r1{wmZ3s\u0011\u00199\u0003\u0001)A\u0005=\u00059An\\4hKJ\u0004\u0003\"B\u0015\u0001\t+Q\u0013!\u00049beN,Wk]3s\u0013:4w\u000e\u0006\u0002,yA!\u0011\u0003\f\u0018/\u0013\ti#C\u0001\u0004UkBdWM\r\t\u0004#=\n\u0014B\u0001\u0019\u0013\u0005\u0019y\u0005\u000f^5p]B\u0011!'\u000f\b\u0003g]\u0002\"\u0001\u000e\n\u000e\u0003UR!A\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\tA$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u0013\u0011\u0015i\u0004\u00061\u0001/\u0003!)8/\u001a:J]\u001a|\u0007bB \u0001\u0005\u00045\t\u0002Q\u0001\u0007'\u000eCU)T#\u0016\u0003\u0005\u0003\"A\u0011$\u000e\u0003\rS!\u0001R#\u0002\u00115\fGo\u00195j]\u001eT!a\u0001\n\n\u0005\u001d\u001b%!\u0002*fO\u0016D\bbB%\u0001\u0005\u00045\tAS\u0001\b\t\u00163\u0015)\u0016'U+\u0005Y\u0005C\u0001'N\u001b\u0005!\u0011B\u0001(\u0005\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")\u0001\u000b\u0001C\u0001#\u0006Q\u0001/\u0019:tK>\u0013H)[3\u0015\u0007-\u0013F\u000bC\u0003T\u001f\u0002\u0007\u0011'A\u0002ve2Dq!V(\u0011\u0002\u0003\u0007a+A\u0004dQ\u0006\u00148/\u001a;\u0011\u0005]kV\"\u0001-\u000b\u0005UK&B\u0001.\\\u0003\rq\u0017n\u001c\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0006LA\u0004DQ\u0006\u00148/\u001a;)\u0007=\u0003\u0017\u000eE\u0002\u0012C\u000eL!A\u0019\n\u0003\rQD'o\\<t!\t!w-D\u0001f\u0015\t1G!\u0001\u0006fq\u000e,\u0007\u000f^5p]NL!\u0001[3\u00033Us\u0017M\u00197f)>\u0004\u0016M]:f+JcU\t_2faRLwN\\\u0011\u0002U\u0006y\u0015N\u001a\u0011uQ\u0016\u0004SK\u0015'!I>,7\u000f\t8pi\u0002j\u0017\r^2iAQDW\rI3ya\u0016\u001cG/\u001a3!if\u0004X\r\f\u0011pe\u0002\u001a\u0017M\u001c8pi\u0002\u0012W\r\t9beN,G\r\t4pe\u0002\ng.\u001f\u0011sK\u0006\u001cxN\u001c\u0005\u0006Y\u0002!\t!\\\u0001\u0006a\u0006\u00148/\u001a\u000b\u0004\u0017:|\u0007\"B*l\u0001\u0004\t\u0004bB+l!\u0003\u0005\rA\u0016\u0005\u0006c\u0002!\tB]\u0001\u0016CN\u001cX-\u001c2mK\u000e{gNZ5hkJ\fG/[8o)\rY5\u000f\u001f\u0005\u0006iB\u0004\r!^\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003\u0002\u001awcEJ!a^\u001e\u0003\u00075\u000b\u0007\u000fC\u0003Va\u0002\u0007a\u000bC\u0003m\u0001\u0011E!\u0010\u0006\u0002vw\")A0\u001fa\u0001{\u0006\u0019QO]5\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taW\u0001\u0004]\u0016$\u0018bAA\u0003\u007f\n\u0019QKU%\t\u000f\u0005%\u0001\u0001\"\u0005\u0002\f\u0005Q\u0001.\u00198eY\u0016TEIQ\"\u0015\u0007U\fi\u0001\u0003\u0004}\u0003\u000f\u0001\r! \u0005\b\u0003#\u0001AQCA\n\u0003E)hn\u001e:ba&\u0003hON1eIJ,7o\u001d\u000b\u0004c\u0005U\u0001bBA\f\u0003\u001f\u0001\r!M\u0001\u0007g\u0016\u0014h/\u001a:\t\u0013\u0005m\u0001!%A\u0005\u0002\u0005u\u0011\u0001\u00069beN,wJ\u001d#jK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002 )\u001aa+!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\t9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u000e\u0001#\u0003%\t!!\b\u0002\u001fA\f'o]3%I\u00164\u0017-\u001e7uII:q!!\u000f\u0003\u0011\u0003\tY$A\tBEN$(/Y2u+JK\u0005+\u0019:tKJ\u00042AGA\u001f\r\u0019\t!\u0001#\u0001\u0002@M\u0019\u0011Q\b\t\t\u000f]\ti\u0004\"\u0001\u0002DQ\u0011\u00111\b\u0005\u000b\u0003\u000f\niD1A\u0005\u0002\u0005%\u0013\u0001\u0002)P%R+\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015\\\u0003\u0011a\u0017M\\4\n\u0007i\ny\u0005C\u0005\u0002X\u0005u\u0002\u0015!\u0003\u0002L\u0005)\u0001k\u0014*UA!Q\u00111LA\u001f\u0005\u0004%\t!!\u0013\u0002\r\u0011\u0013e*Q'F\u0011%\ty&!\u0010!\u0002\u0013\tY%A\u0004E\u0005:\u000bU*\u0012\u0011\t\u0015\u0005\r\u0014Q\bb\u0001\n\u0003\tI%\u0001\u0003I\u001fN#\u0006\"CA4\u0003{\u0001\u000b\u0011BA&\u0003\u0015Auj\u0015+!\u0011)\tY'!\u0010C\u0002\u0013\u0005\u0011\u0011J\u0001\t+N+%KT!N\u000b\"I\u0011qNA\u001fA\u0003%\u00111J\u0001\n+N+%KT!N\u000b\u0002B!\"a\u001d\u0002>\t\u0007I\u0011AA%\u0003!\u0001\u0016iU*X\u001fJ#\u0005\"CA<\u0003{\u0001\u000b\u0011BA&\u0003%\u0001\u0016iU*X\u001fJ#\u0005\u0005")
public abstract class AbstractURIParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static String PASSWORD() {
        return AbstractURIParser$.MODULE$.PASSWORD();
    }

    public static String USERNAME() {
        return AbstractURIParser$.MODULE$.USERNAME();
    }

    public static String HOST() {
        return AbstractURIParser$.MODULE$.HOST();
    }

    public static String DBNAME() {
        return AbstractURIParser$.MODULE$.DBNAME();
    }

    public static String PORT() {
        return AbstractURIParser$.MODULE$.PORT();
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Tuple2<Option<String>, Option<String>> parseUserInfo(Option<String> userInfo) {
        boolean bl = false;
        Some some = null;
        Option option = userInfo.map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(":", 2))).toList());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            List list = (List)some.value();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                String user = (String)colon2.head();
                List list2 = colon2.tl$access$1();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    String pass = (String)colon3.head();
                    List list3 = colon3.tl$access$1();
                    if (Nil$.MODULE$.equals(list3)) {
                        return new Tuple2((Object)new Some((Object)user), (Object)new Some((Object)pass));
                    }
                }
            }
        }
        if (!bl) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        List list = (List)some.value();
        if (!(list instanceof .colon.colon)) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        .colon.colon colon4 = (.colon.colon)list;
        String user = (String)colon4.head();
        List list4 = colon4.tl$access$1();
        if (!Nil$.MODULE$.equals(list4)) return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        return new Tuple2((Object)new Some((Object)user), (Object)None$.MODULE$);
    }

    public abstract Regex SCHEME();

    public abstract Configuration DEFAULT();

    public Configuration parseOrDie(String url, Charset charset) throws UnableToParseURLException {
        Configuration configuration;
        try {
            Map<String, String> properties = this.parse(new URI(url).parseServerAuthority());
            configuration = this.assembleConfiguration(properties, charset);
        }
        catch (URISyntaxException e) {
            throw new UnableToParseURLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse URL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})), e);
        }
        return configuration;
    }

    public Configuration parse(String url, Charset charset) {
        Configuration configuration;
        try {
            configuration = this.parseOrDie(url, charset);
        }
        catch (Exception e) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection url '", "' could not be parsed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})), (Throwable)e);
            configuration = this.DEFAULT();
        }
        return configuration;
    }

    public Configuration assembleConfiguration(Map<String, String> properties, Charset charset) {
        String x$15 = (String)properties.getOrElse((Object)AbstractURIParser$.MODULE$.USERNAME(), (Function0 & Serializable & scala.Serializable)() -> this.DEFAULT().username());
        Option x$16 = properties.get((Object)AbstractURIParser$.MODULE$.PASSWORD());
        Option x$17 = properties.get((Object)AbstractURIParser$.MODULE$.DBNAME());
        String x$18 = (String)properties.getOrElse((Object)AbstractURIParser$.MODULE$.HOST(), (Function0 & Serializable & scala.Serializable)() -> this.DEFAULT().host());
        int x$19 = BoxesRunTime.unboxToInt((Object)properties.get((Object)AbstractURIParser$.MODULE$.PORT()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)AbstractURIParser.$anonfun$assembleConfiguration$3(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.DEFAULT().port()));
        SSLConfiguration x$20 = SSLConfiguration$.MODULE$.apply(properties);
        Charset x$21 = charset;
        int x$22 = this.DEFAULT().copy$default$8();
        ByteBufAllocator x$23 = this.DEFAULT().copy$default$9();
        Duration x$24 = this.DEFAULT().copy$default$10();
        Duration x$25 = this.DEFAULT().copy$default$11();
        Option<Duration> x$26 = this.DEFAULT().copy$default$12();
        return this.DEFAULT().copy(x$15, x$18, x$19, (Option<String>)x$16, (Option<String>)x$17, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
    }

    public Map<String, String> parse(URI uri) {
        Map map;
        String string = uri.getScheme();
        Option option = this.SCHEME().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            Tuple2<Option<String>, Option<String>> userInfo = this.parseUserInfo((Option<String>)Option$.MODULE$.apply((Object)uri.getUserInfo()));
            Option port = new Some((Object)BoxesRunTime.boxToInteger((int)uri.getPort())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 > 0);
            Option db = Option$.MODULE$.apply((Object)uri.getPath()).map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString(x$4)).stripPrefix("/")).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()));
            Option host = Option$.MODULE$.apply((Object)uri.getHost());
            Builder builder = Predef$.MODULE$.Map().newBuilder();
            builder.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(((Option)userInfo._1()).map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.USERNAME()), x$6))));
            builder.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(((Option)userInfo._2()).map((Function1 & Serializable & scala.Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.PASSWORD()), x$7))));
            builder.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(port.map((Function1 & Serializable & scala.Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.PORT()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$8))).toString()))));
            builder.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(db.map((Function1 & Serializable & scala.Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.DBNAME()), x$9))));
            builder.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(host.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.HOST()), (Object)this.unwrapIpv6address((String)x$10)))));
            builder.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)uri.getQuery())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)qs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(qs)).split('&'))).map((Function1 & Serializable & scala.Serializable)parameter -> {
                String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(parameter)).split('=');
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String name = (String)((SeqLike)option.get()).apply(0);
                String value = (String)((SeqLike)option.get()).apply(1);
                Tuple3 tuple3 = new Tuple3((Object)stringArray, (Object)name, (Object)value);
                Tuple3 tuple32 = tuple3;
                String[] x$11 = (String[])tuple32._1();
                String name2 = (String)tuple32._2();
                String value2 = (String)tuple32._3();
                return new Tuple2(parameter, (Object)x$11);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AbstractURIParser.$anonfun$parse$11(x$13))).map((Function1 & Serializable & scala.Serializable)x$14 -> {
                String[] stringArray;
                Option option;
                Tuple2 tuple2 = x$14;
                if (tuple2 == null || (option = Array$.MODULE$.unapplySeq((Object)(stringArray = (String[])tuple2._2()))).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)((SeqLike)option.get()).apply(0);
                String value = (String)((SeqLike)option.get()).apply(1);
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)URLDecoder.decode(name, "UTF-8")), (Object)URLDecoder.decode(value, "UTF-8"));
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))), Seq$.MODULE$.canBuildFrom()));
            map = (Map)builder.result();
        } else if ("jdbc".equals(string)) {
            map = this.handleJDBC(uri);
        } else {
            throw new UnableToParseURLException("Unrecognized URI scheme");
        }
        return map;
    }

    public Charset parseOrDie$default$2() {
        return this.DEFAULT().charset();
    }

    public Charset parse$default$2() {
        return this.DEFAULT().charset();
    }

    public Map<String, String> handleJDBC(URI uri) {
        return this.parse(new URI(uri.getSchemeSpecificPart()));
    }

    public final String unwrapIpv6address(String server) {
        return server.startsWith("[") ? server.substring(1, server.length() - 1) : server;
    }

    public static final /* synthetic */ int $anonfun$assembleConfiguration$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parse$11(Tuple2 x$13) {
        String[] stringArray;
        Option option;
        Tuple2 tuple2 = x$13;
        if (tuple2 == null || (option = Array$.MODULE$.unapplySeq((Object)(stringArray = (String[])tuple2._2()))).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)((SeqLike)option.get()).apply(0);
        String value = (String)((SeqLike)option.get()).apply(1);
        boolean bl = new StringOps(Predef$.MODULE$.augmentString(name)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty();
        return bl;
    }
}

