/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.kubernetes;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfigMapStore
implements ConfigStore {
    private static final String KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE");
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final Vertx vertx;
    private final JsonObject configuration;
    private final String namespace;
    private final String name;
    private final String key;
    private final boolean secret;
    private final boolean optional;
    private final Context ctx;
    private final WebClient client;
    private String token;

    public ConfigMapStore(Vertx vertx, JsonObject configuration) {
        String p;
        this.vertx = vertx;
        this.configuration = configuration;
        this.ctx = vertx.getOrCreateContext();
        String ns = configuration.getString("namespace");
        if (ns == null) {
            ns = KUBERNETES_NAMESPACE != null ? KUBERNETES_NAMESPACE : "default";
        }
        this.optional = configuration.getBoolean("optional", Boolean.valueOf(true));
        this.namespace = ns;
        this.name = configuration.getString("name");
        this.key = configuration.getString("key");
        this.secret = configuration.getBoolean("secret", Boolean.valueOf(false));
        int port = configuration.getInteger("port", Integer.valueOf(0));
        if (port == 0) {
            port = configuration.getBoolean("ssl", Boolean.valueOf(true)) != false ? 443 : 80;
        }
        if ((p = System.getenv("KUBERNETES_SERVICE_PORT")) != null) {
            port = Integer.valueOf(p);
        }
        String host = configuration.getString("host");
        String h = System.getenv("KUBERNETES_SERVICE_HOST");
        if (h != null) {
            host = h;
        }
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setTrustAll(true).setSsl(configuration.getBoolean("ssl", Boolean.valueOf(true)).booleanValue()).setDefaultHost(host).setDefaultPort(port).setFollowRedirects(true));
        Objects.requireNonNull(this.name);
    }

    public synchronized void close(Handler<Void> completionHandler) {
        this.runOnContext((Handler<Void>)((Handler)v -> this.closeOnContext(completionHandler)));
    }

    private synchronized void closeOnContext(Handler<Void> completionHandler) {
        if (this.client != null) {
            this.client.close();
        }
        if (completionHandler != null) {
            completionHandler.handle(null);
        }
    }

    private void runOnContext(Handler<Void> action) {
        if (Vertx.currentContext() == this.ctx) {
            action.handle(null);
        } else {
            this.ctx.runOnContext(action);
        }
    }

    private Future<String> getToken() {
        Future result = Future.future();
        String token = this.configuration.getString("token");
        if (token != null && !token.trim().isEmpty()) {
            this.token = token;
            result.complete((Object)token);
            return result;
        }
        this.vertx.fileSystem().readFile("/var/run/secrets/kubernetes.io/serviceaccount/token", ar -> {
            if (ar.failed()) {
                if (this.optional) {
                    this.token = "";
                    result.tryComplete((Object)this.token);
                } else {
                    result.tryFail(ar.cause());
                }
            } else {
                this.token = ((Buffer)ar.result()).toString();
                result.tryComplete((Object)((Buffer)ar.result()).toString());
            }
        });
        return result;
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.runOnContext((Handler<Void>)((Handler)v -> this.getOnContext(completionHandler)));
    }

    private synchronized void getOnContext(Handler<AsyncResult<Buffer>> completionHandler) {
        Future retrieveToken = this.token == null ? this.getToken() : Future.succeededFuture((Object)this.token);
        retrieveToken.compose(token -> {
            Future future = Future.future();
            if (token.isEmpty()) {
                future.complete((Object)Buffer.buffer((String)"{}"));
                return future;
            }
            String path = "/api/v1/namespaces/" + this.namespace;
            path = this.secret ? path + "/secrets/" + this.name : path + "/configmaps/" + this.name;
            this.client.get(path).putHeader("Authorization", "Bearer " + token).send(ar -> {
                if (ar.failed()) {
                    completionHandler.handle((Object)ar.mapEmpty());
                    return;
                }
                HttpResponse response = (HttpResponse)ar.result();
                if (response.statusCode() == 404) {
                    if (this.optional) {
                        future.complete((Object)Buffer.buffer((String)"{}"));
                    } else {
                        future.fail("Cannot find the config map '" + this.name + "' in '" + this.namespace + "'");
                    }
                } else if (response.statusCode() == 403) {
                    completionHandler.handle((Object)Future.failedFuture((String)("Access denied to configmap or secret in namespace " + this.namespace + ": " + this.name)));
                } else if (response.statusCode() != 200) {
                    if (this.optional) {
                        future.complete((Object)Buffer.buffer((String)"{}"));
                    } else {
                        completionHandler.handle((Object)Future.failedFuture((String)("Cannot retrieve the configmap or secret in namespace " + this.namespace + ": " + this.name + ", status code: " + response.statusCode() + ", error: " + response.bodyAsString())));
                    }
                } else {
                    JsonObject data = response.bodyAsJsonObject().getJsonObject("data");
                    if (data == null) {
                        future.fail("Invalid secret of configmap in namespace " + this.namespace + " " + this.name + ", the data entry is empty");
                        return;
                    }
                    if (this.key == null) {
                        if (this.secret) {
                            future.complete((Object)new JsonObject(ConfigMapStore.asSecretObjectMap(data.getMap())).toBuffer());
                        } else {
                            future.complete((Object)new JsonObject(ConfigMapStore.asObjectMap(data.getMap())).toBuffer());
                        }
                    } else {
                        String string = data.getString(this.key);
                        if (string == null) {
                            future.fail("Cannot find key '" + this.key + "' in the configmap or secret '" + this.name + "'");
                        } else if (this.secret) {
                            future.complete((Object)Buffer.buffer((byte[])DECODER.decode(string)));
                        } else {
                            future.complete((Object)Buffer.buffer((String)string));
                        }
                    }
                }
            });
            return future;
        }).setHandler(completionHandler);
    }

    private static Map<String, Object> asObjectMap(Map<String, Object> source) {
        if (source == null) {
            return new HashMap<String, Object>();
        }
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonObjectHelper.convert((String)entry.getValue().toString())));
    }

    private static Map<String, Object> asSecretObjectMap(Map<String, Object> source) {
        if (source == null) {
            return new HashMap<String, Object>();
        }
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String encodedString = entry.getValue().toString();
            String decodedString = new String(DECODER.decode(encodedString), StandardCharsets.UTF_8);
            return JsonObjectHelper.convert((String)decodedString);
        }));
    }
}

