/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.Match;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MicrometerMetricsOptionsConverter;
import io.vertx.micrometer.VertxInfluxDbOptions;
import io.vertx.micrometer.VertxJmxMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DataObject(generateConverter=true, inheritConverter=true)
public class MicrometerMetricsOptions
extends MetricsOptions {
    public static final String DEFAULT_REGISTRY_NAME = "default";
    public static final List<Label> DEFAULT_LABELS = Arrays.asList(Label.HTTP_METHOD, Label.HTTP_CODE, Label.POOL_TYPE, Label.EB_SIDE);
    public static final boolean DEFAULT_JVM_METRICS_ENABLED = false;
    private Set<MetricsDomain> disabledMetricsCategories;
    private String registryName;
    private Set<Label> labels;
    private List<Match> labelMatches;
    private MeterRegistry micrometerRegistry;
    private VertxInfluxDbOptions influxDbOptions;
    private VertxPrometheusOptions prometheusOptions;
    private VertxJmxMetricsOptions jmxMetricsOptions;
    private boolean jvmMetricsEnabled;

    public MicrometerMetricsOptions() {
        this.disabledMetricsCategories = EnumSet.noneOf(MetricsDomain.class);
        this.registryName = DEFAULT_REGISTRY_NAME;
        this.labels = EnumSet.copyOf(DEFAULT_LABELS);
        this.labelMatches = new ArrayList<Match>();
        this.jvmMetricsEnabled = false;
    }

    public MicrometerMetricsOptions(MicrometerMetricsOptions other) {
        super((MetricsOptions)other);
        this.disabledMetricsCategories = other.disabledMetricsCategories != null ? EnumSet.copyOf(other.disabledMetricsCategories) : EnumSet.noneOf(MetricsDomain.class);
        this.registryName = other.registryName;
        this.labels = other.labels != null ? EnumSet.copyOf(other.labels) : EnumSet.noneOf(Label.class);
        this.labelMatches = new ArrayList<Match>(other.labelMatches);
        this.micrometerRegistry = other.micrometerRegistry;
        if (other.influxDbOptions != null) {
            this.influxDbOptions = new VertxInfluxDbOptions(other.influxDbOptions);
        }
        if (other.prometheusOptions != null) {
            this.prometheusOptions = new VertxPrometheusOptions(other.prometheusOptions);
        }
        if (other.jmxMetricsOptions != null) {
            this.jmxMetricsOptions = new VertxJmxMetricsOptions(other.jmxMetricsOptions);
        }
        this.jvmMetricsEnabled = other.jvmMetricsEnabled;
    }

    public MicrometerMetricsOptions(JsonObject json) {
        this();
        MicrometerMetricsOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.labelMatches = this.loadLabelMatches(json);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        MicrometerMetricsOptionsConverter.toJson(this, json);
        return json;
    }

    private List<Match> loadLabelMatches(JsonObject json) {
        ArrayList<Match> list = new ArrayList<Match>();
        JsonArray monitored = json.getJsonArray("labelMatches", new JsonArray());
        monitored.forEach(object -> {
            if (object instanceof JsonObject) {
                list.add(new Match((JsonObject)object));
            }
        });
        return list;
    }

    public MicrometerMetricsOptions setEnabled(boolean enable) {
        super.setEnabled(enable);
        return this;
    }

    public Set<MetricsDomain> getDisabledMetricsCategories() {
        return this.disabledMetricsCategories;
    }

    public MicrometerMetricsOptions setDisabledMetricsCategories(Set<MetricsDomain> disabledMetricsCategories) {
        this.disabledMetricsCategories = disabledMetricsCategories;
        return this;
    }

    @GenIgnore
    public MicrometerMetricsOptions addDisabledMetricsCategory(MetricsDomain metricsDomain) {
        if (this.disabledMetricsCategories == null) {
            this.disabledMetricsCategories = EnumSet.noneOf(MetricsDomain.class);
        }
        this.disabledMetricsCategories.add(metricsDomain);
        return this;
    }

    @GenIgnore
    public boolean isMetricsCategoryDisabled(MetricsDomain metricsDomain) {
        return this.disabledMetricsCategories != null && this.disabledMetricsCategories.contains((Object)metricsDomain);
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public MicrometerMetricsOptions setRegistryName(String registryName) {
        this.registryName = registryName;
        return this;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public MicrometerMetricsOptions setLabels(Set<Label> labels) {
        this.labels = labels;
        return this;
    }

    @GenIgnore
    public MicrometerMetricsOptions addLabels(Label ... labels) {
        if (this.labels == null) {
            this.labels = EnumSet.noneOf(Label.class);
        }
        this.labels.addAll(Arrays.asList(labels));
        return this;
    }

    public List<Match> getLabelMatches() {
        return this.labelMatches;
    }

    public MicrometerMetricsOptions setLabelMatches(List<Match> matches) {
        this.labelMatches = new ArrayList<Match>(matches);
        return this;
    }

    public MicrometerMetricsOptions addLabelMatch(Match match) {
        this.labelMatches.add(match);
        return this;
    }

    public MeterRegistry getMicrometerRegistry() {
        return this.micrometerRegistry;
    }

    public MicrometerMetricsOptions setMicrometerRegistry(MeterRegistry micrometerRegistry) {
        this.micrometerRegistry = micrometerRegistry;
        return this;
    }

    public VertxInfluxDbOptions getInfluxDbOptions() {
        return this.influxDbOptions;
    }

    public MicrometerMetricsOptions setInfluxDbOptions(VertxInfluxDbOptions influxDbOptions) {
        this.influxDbOptions = influxDbOptions;
        return this;
    }

    public VertxPrometheusOptions getPrometheusOptions() {
        return this.prometheusOptions;
    }

    public MicrometerMetricsOptions setPrometheusOptions(VertxPrometheusOptions prometheusOptions) {
        this.prometheusOptions = prometheusOptions;
        return this;
    }

    public VertxJmxMetricsOptions getJmxMetricsOptions() {
        return this.jmxMetricsOptions;
    }

    public MicrometerMetricsOptions setJmxMetricsOptions(VertxJmxMetricsOptions jmxMetricsOptions) {
        this.jmxMetricsOptions = jmxMetricsOptions;
        return this;
    }

    public boolean isJvmMetricsEnabled() {
        return this.jvmMetricsEnabled;
    }

    public MicrometerMetricsOptions setJvmMetricsEnabled(boolean jvmMetricsEnabled) {
        this.jvmMetricsEnabled = jvmMetricsEnabled;
        return this;
    }
}

