/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.Labels;
import java.util.concurrent.TimeUnit;

public class Timers {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final MeterRegistry registry;

    public Timers(String name, String description, MeterRegistry registry, Label ... keys) {
        this.name = name;
        this.description = description;
        this.registry = registry;
        this.keys = keys;
    }

    public Timer get(String ... values) {
        return Timer.builder((String)this.name).description(this.description).tags(Labels.toTags(this.keys, values)).register(this.registry);
    }

    public EventTiming start(String ... values) {
        Timer t = this.get(values);
        return new EventTiming(t);
    }

    public static class EventTiming {
        private final Timer timer;
        private final long nanoStart;

        private EventTiming(Timer timer) {
            this.timer = timer;
            this.nanoStart = System.nanoTime();
        }

        public void end() {
            this.timer.record(System.nanoTime() - this.nanoStart, TimeUnit.NANOSECONDS);
        }
    }
}

