require 'vertx/read_stream'
require 'vertx/util/utils.rb'
# Generated from io.vertx.cassandra.CassandraRowStream
module VertxCassandra
  #  A  for  consumption.
  class CassandraRowStream
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxCassandra::CassandraRowStream] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCassandra::CassandraRowStream] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CassandraRowStream
    end
    def @@j_api_type.wrap(obj)
      CassandraRowStream.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCassandra::CassandraRowStream.java_class
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    # @param [Fixnum] l 
    # @return [self]
    def fetch(l=nil)
      if l.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(l)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{l})"
    end
  end
end
