require 'vertx/util/utils.rb'
# Generated from io.vertx.rabbitmq.BasicProperties
module VertxRabbitmq
  #  Like BasicProperties
  class BasicProperties
    # @private
    # @param j_del [::VertxRabbitmq::BasicProperties] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRabbitmq::BasicProperties] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BasicProperties
    end
    def @@j_api_type.wrap(obj)
      BasicProperties.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRabbitmq::BasicProperties.java_class
    end
    # @return [String] contentType of a message, or <code>null</code> if it has not been set.
    def content_type
      if !block_given?
        if @cached_content_type != nil
          return @cached_content_type
        end
        return @cached_content_type = @j_del.java_method(:contentType, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling content_type()"
    end
    # @return [String] contentEncoding of a message, or <code>null</code> if it has not been set.
    def content_encoding
      if !block_given?
        if @cached_content_encoding != nil
          return @cached_content_encoding
        end
        return @cached_content_encoding = @j_del.java_method(:contentEncoding, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling content_encoding()"
    end
    # @return [Fixnum] deliveryMode of a message, or <code>null</code> if it has not been set.
    def delivery_mode
      if !block_given?
        if @cached_delivery_mode != nil
          return @cached_delivery_mode
        end
        return @cached_delivery_mode = @j_del.java_method(:deliveryMode, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling delivery_mode()"
    end
    #  Retrieve the value in the priority field.
    # @return [Fixnum] priority of a message, or <code>null</code> if it has not been set.
    def priority
      if !block_given?
        if @cached_priority != nil
          return @cached_priority
        end
        return @cached_priority = @j_del.java_method(:priority, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling priority()"
    end
    # @return [String] correlationId of a message, or <code>null</code> if it has not been set.
    def correlation_id
      if !block_given?
        if @cached_correlation_id != nil
          return @cached_correlation_id
        end
        return @cached_correlation_id = @j_del.java_method(:correlationId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling correlation_id()"
    end
    # @return [String] replyTo address, or <code>null</code> if it has not been set.
    def reply_to
      if !block_given?
        if @cached_reply_to != nil
          return @cached_reply_to
        end
        return @cached_reply_to = @j_del.java_method(:replyTo, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling reply_to()"
    end
    # @return [String] expiration of a message, or <code>null</code> if it has not been set.
    def expiration
      if !block_given?
        if @cached_expiration != nil
          return @cached_expiration
        end
        return @cached_expiration = @j_del.java_method(:expiration, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling expiration()"
    end
    # @return [String] messageId, or <code>null</code> if it has not been set.
    def message_id
      if !block_given?
        if @cached_message_id != nil
          return @cached_message_id
        end
        return @cached_message_id = @j_del.java_method(:messageId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling message_id()"
    end
    # @return [Fixnum] timestamp of a message, or <code>null</code> if it has not been set.
    def timestamp
      if !block_given?
        if @cached_timestamp != nil
          return @cached_timestamp
        end
        return @cached_timestamp = @j_del.java_method(:timestamp, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling timestamp()"
    end
    # @return [String] type of a message, or <code>null</code> if it has not been set.
    def type
      if !block_given?
        if @cached_type != nil
          return @cached_type
        end
        return @cached_type = @j_del.java_method(:type, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling type()"
    end
    # @return [String] userId, or <code>null</code> if it has not been set.
    def user_id
      if !block_given?
        if @cached_user_id != nil
          return @cached_user_id
        end
        return @cached_user_id = @j_del.java_method(:userId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling user_id()"
    end
    # @return [String] appId, or <code>null</code> if it has not been set.
    def app_id
      if !block_given?
        if @cached_app_id != nil
          return @cached_app_id
        end
        return @cached_app_id = @j_del.java_method(:appId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling app_id()"
    end
    # @return [String] clusterId, or <code>null</code> if it has not been set.
    def cluster_id
      if !block_given?
        if @cached_cluster_id != nil
          return @cached_cluster_id
        end
        return @cached_cluster_id = @j_del.java_method(:clusterId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling cluster_id()"
    end
  end
end
