require 'vertx/buffer'
require 'vertx/read_stream'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.parsetools.RecordParser
module Vertx
  #  A helper class which allows you to easily parse protocols which are delimited by a sequence of bytes, or fixed
  #  size records.
  #  <p>
  #  Instances of this class take as input {::Vertx::Buffer} instances containing raw bytes,
  #  and output records.
  #  <p>
  #  For example, if I had a simple ASCII text protocol delimited by '\n' and the input was the following:
  #  <p>
  #  <pre>
  #  buffer1:HELLO\nHOW ARE Y
  #  buffer2:OU?\nI AM
  #  buffer3: DOING OK
  #  buffer4:\n
  #  </pre>
  #  Then the output would be:<p>
  #  <pre>
  #  buffer1:HELLO
  #  buffer2:HOW ARE YOU?
  #  buffer3:I AM DOING OK
  #  </pre>
  #  Instances of this class can be changed between delimited mode and fixed size record mode on the fly as
  #  individual records are read, this allows you to parse protocols where, for example, the first 5 records might
  #  all be fixed size (of potentially different sizes), followed by some delimited records, followed by more fixed
  #  size records.
  #  <p>
  #  Instances of this class can't currently be used for protocols where the text is encoded with something other than
  #  a 1-1 byte-char mapping.
  #  <p>
  #  Please see the documentation for more information.
  class RecordParser
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::RecordParser] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::RecordParser] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RecordParser
    end
    def @@j_api_type.wrap(obj)
      RecordParser.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreParsetools::RecordParser.java_class
    end
    # @yield 
    # @return [void]
    def set_output
      if block_given?
        return @j_del.java_method(:setOutput, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) }))
      end
      raise ArgumentError, "Invalid arguments when calling set_output()"
    end
    #  Like {::Vertx::RecordParser#new_delimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
    #  when the {::Vertx::RecordParser#handler} is set.
    #  <p/>
    #  The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
    # @overload newDelimited(delim)
    #   @param [String] delim the initial delimiter string
    # @overload newDelimited(delim)
    #   @param [::Vertx::Buffer] delim the initial delimiter buffer
    # @overload newDelimited(delim,output)
    #   @param [String] delim the initial delimiter string
    #   @yield handler that will receive the output
    # @overload newDelimited(delim,stream)
    #   @param [String] delim the initial delimiter string
    #   @param [::Vertx::ReadStream] stream the wrapped stream
    # @overload newDelimited(delim,output)
    #   @param [::Vertx::Buffer] delim the initial delimiter buffer
    #   @yield handler that will receive the output
    # @overload newDelimited(delim,stream)
    #   @param [::Vertx::Buffer] delim the initial delimiter buffer
    #   @param [::Vertx::ReadStream] stream the wrapped stream
    # @return [::Vertx::RecordParser]
    def self.new_delimited(param_1=nil,param_2=nil)
      if param_1.class == String && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::java.lang.String.java_class]).call(param_1),::Vertx::RecordParser)
      elsif param_1.class.method_defined?(:j_del) && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(param_1.j_del),::Vertx::RecordParser)
      elsif param_1.class == String && block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) })),::Vertx::RecordParser)
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::java.lang.String.java_class,Java::IoVertxCoreStreams::ReadStream.java_class]).call(param_1,param_2.j_del),::Vertx::RecordParser)
      elsif param_1.class.method_defined?(:j_del) && block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) })),::Vertx::RecordParser)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newDelimited, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCoreStreams::ReadStream.java_class]).call(param_1.j_del,param_2.j_del),::Vertx::RecordParser)
      end
      raise ArgumentError, "Invalid arguments when calling new_delimited(#{param_1},#{param_2})"
    end
    #  Like {::Vertx::RecordParser#new_fixed} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
    #  when the {::Vertx::RecordParser#handler} is set.
    #  <p/>
    #  The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
    # @param [Fixnum] size the initial record size
    # @param [::Vertx::ReadStream] stream the wrapped stream
    # @return [::Vertx::RecordParser]
    def self.new_fixed(size=nil,stream=nil)
      if size.class == Fixnum && !block_given? && stream == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newFixed, [Java::int.java_class]).call(size),::Vertx::RecordParser)
      elsif size.class == Fixnum && block_given? && stream == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newFixed, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(size,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) })),::Vertx::RecordParser)
      elsif size.class == Fixnum && stream.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreParsetools::RecordParser.java_method(:newFixed, [Java::int.java_class,Java::IoVertxCoreStreams::ReadStream.java_class]).call(size,stream.j_del),::Vertx::RecordParser)
      end
      raise ArgumentError, "Invalid arguments when calling new_fixed(#{size},#{stream})"
    end
    #  Flip the parser into delimited mode, and where the delimiter can be represented
    #  by the delimiter <code>delim</code>.
    #  <p>
    #  This method can be called multiple times with different values of delim while data is being parsed.
    # @overload delimitedMode(delim)
    #   @param [String] delim the new delimeter
    # @overload delimitedMode(delim)
    #   @param [::Vertx::Buffer] delim the new delimiter
    # @return [void]
    def delimited_mode(param_1=nil)
      if param_1.class == String && !block_given?
        return @j_del.java_method(:delimitedMode, [Java::java.lang.String.java_class]).call(param_1)
      elsif param_1.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:delimitedMode, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(param_1.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling delimited_mode(#{param_1})"
    end
    #  Flip the parser into fixed size mode, where the record size is specified by <code>size</code> in bytes.
    #  <p>
    #  This method can be called multiple times with different values of size while data is being parsed.
    # @param [Fixnum] size the new record size
    # @return [void]
    def fixed_size_mode(size=nil)
      if size.class == Fixnum && !block_given?
        return @j_del.java_method(:fixedSizeMode, [Java::int.java_class]).call(size)
      end
      raise ArgumentError, "Invalid arguments when calling fixed_size_mode(#{size})"
    end
    #  Set the maximum allowed size for a record when using the delimited mode.
    #  The delimiter itself does not count for the record size.
    #  <p>
    #  If a record is longer than specified, an IllegalStateException will be thrown.
    # @param [Fixnum] size the maximum record size
    # @return [self]
    def max_record_size(size=nil)
      if size.class == Fixnum && !block_given?
        @j_del.java_method(:maxRecordSize, [Java::int.java_class]).call(size)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling max_record_size(#{size})"
    end
    #  This method is called to provide the parser with data.
    # @param [::Vertx::Buffer] buffer a chunk of data
    # @return [void]
    def handle(buffer=nil)
      if buffer.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(buffer.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{buffer})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
  end
end
