/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-cassandra-js/cassandra_row_stream */
var utils = require('vertx-js/util/utils');
var ReadStream = require('vertx-js/read_stream');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCassandraRowStream = Java.type('io.vertx.cassandra.CassandraRowStream');

/**

 @class
*/
var CassandraRowStream = function(j_val) {

  var j_cassandraRowStream = j_val;
  var that = this;
  ReadStream.call(this, j_val);

  /**

   @public
   @param handler {function} 
   @return {CassandraRowStream}
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_cassandraRowStream["exceptionHandler(io.vertx.core.Handler)"](handler == null ? null : function(jVal) {
        handler(utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {CassandraRowStream}
   */
  this.pause =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_cassandraRowStream["pause()"]() ;
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {CassandraRowStream}
   */
  this.resume =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_cassandraRowStream["resume()"]() ;
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {CassandraRowStream}
   */
  this.endHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'function' || __args[0] == null)) {
      j_cassandraRowStream["endHandler(io.vertx.core.Handler)"](handler) ;
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param l {number} 
   @return {CassandraRowStream}
   */
  this.fetch =  function(l) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_cassandraRowStream["fetch(long)"](l) ;
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_cassandraRowStream;
};

CassandraRowStream._jclass = utils.getJavaClass("io.vertx.cassandra.CassandraRowStream");
CassandraRowStream._jtype = {accept: function(obj) {
    return CassandraRowStream._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CassandraRowStream.prototype, {});
    CassandraRowStream.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CassandraRowStream._create = function(jdel) {var obj = Object.create(CassandraRowStream.prototype, {});
  CassandraRowStream.apply(obj, arguments);
  return obj;
}
module.exports = CassandraRowStream;