/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeStAXStreamBuilder;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.jdom.JDOMInterner;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.filter.Filter;

public class JDOMUtil {
    private static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = new Condition<Attribute>(){

        @Override
        public boolean value(Attribute attribute) {
            return !StringUtil.isEmpty(attribute.getValue());
        }
    };
    private static final NotNullLazyValue<XMLInputFactory> XML_INPUT_FACTORY = new NotNullLazyValue<XMLInputFactory>(){

        @Override
        @NotNull
        protected XMLInputFactory compute() {
            XMLInputFactory factory2;
            try {
                Class<?> clazz = Class.forName("com.sun.xml.internal.stream.XMLInputFactoryImpl");
                factory2 = (XMLInputFactory)clazz.newInstance();
            }
            catch (Exception e) {
                factory2 = XMLInputFactory.newFactory();
            }
            try {
                factory2.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", true);
            }
            catch (Exception e) {
                JDOMUtil.getLogger().error("cannot set \"report-cdata-event\" property for XMLInputFactory", e);
            }
            factory2.setProperty("javax.xml.stream.isCoalescing", true);
            factory2.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory2.setProperty("javax.xml.stream.supportDTD", false);
            XMLInputFactory xMLInputFactory = factory2;
            if (xMLInputFactory == null) {
                2.$$$reportNull$$$0(0);
            }
            return xMLInputFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$2", "compute"));
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();
    private static final JDOMInterner ourJDOMInterner = new JDOMInterner();

    private JDOMUtil() {
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader) throws JDOMException, IOException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        XMLStreamReader xmlStreamReader = XML_INPUT_FACTORY.getValue().createXMLStreamReader(reader);
        Element element = SafeStAXStreamBuilder.build(xmlStreamReader, true);
        xmlStreamReader.close();
        Element element2 = element;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(18);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream2) throws JDOMException, IOException {
        if (stream2 == null) {
            return null;
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(stream2, CharsetToolkit.UTF8_CHARSET));
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream2;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        if (resource == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        if ((stream2 = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Element element = JDOMUtil.load(stream2);
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        return element;
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        Element element = JDOMUtil.load(URLUtil.openStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        return element;
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(40);
        }
        Element element = JDOMUtil.load(URLUtil.openResourceStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(41);
        }
        return element;
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || !element.hasAttributes() && element.getContent().isEmpty();
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(97);
        }
        Element element2 = ourJDOMInterner.internElement(element);
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(98);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 15: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 25: 
            case 27: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 42: 
            case 44: 
            case 55: 
            case 60: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 57: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 88: 
            case 89: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: 
            case 59: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 69: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 82: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocument";
                break;
            }
            case 22: 
            case 28: 
            case 33: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResourceDocument";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 64: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 72: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputter";
                break;
            }
            case 83: 
            case 85: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 19: 
            case 23: 
            case 25: 
            case 29: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 21: 
            case 27: 
            case 31: 
            case 32: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceDocument";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 55: 
            case 56: 
            case 60: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 82: 
            case 84: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");
    }
}

