/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PackageScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

abstract class KtNamedDeclarationStub<T extends KotlinStubWithFqName<?>>
extends KtDeclarationStub<T>
implements KtNamedDeclaration {
    private static final Set<String> FUNCTIONLIKE_CONVENTIONS = ImmutableSet.of(OperatorNameConventions.INVOKE.asString(), OperatorNameConventions.GET.asString());

    public KtNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public KtNamedDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @Override
    public String getName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text2 = identifier.getText();
            return text2 != null ? KtPsiUtil.unquoteIdentifier(text2) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name = this.getName();
        return name != null ? Name.identifier(name) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        Name name = KtPsiUtil.safeName(this.getName());
        if (name == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(3);
        }
        return name;
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findChildByType(KtTokens.IDENTIFIER);
    }

    private static boolean shouldDropOperatorKeyword(String oldName, String newName2) {
        return !OperatorConventions.isConventionName(Name.identifier(newName2)) || FUNCTIONLIKE_CONVENTIONS.contains(oldName) != FUNCTIONLIKE_CONVENTIONS.contains(newName2);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement newIdentifier;
        PsiElement identifier;
        if (name == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(4);
        }
        if ((identifier = this.getNameIdentifier()) == null) {
            return null;
        }
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.OPERATOR_KEYWORD) && KtNamedDeclarationStub.shouldDropOperatorKeyword(this.getName(), name)) {
            this.removeModifier(KtTokens.OPERATOR_KEYWORD);
        }
        if ((newIdentifier = KtPsiFactoryKt.KtPsiFactory(this).createNameIdentifierIfPossible(KtPsiUtilKt.quoteIfNeeded(name))) != null) {
            KtPsiUtilKt.astReplace(identifier, newIdentifier);
        } else {
            identifier.delete();
        }
        return this;
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement grandParent;
        KtElement enclosingBlock = KtPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            KtExpression condition;
            PsiElement enclosingParent = enclosingBlock.getParent();
            if (enclosingParent instanceof KtContainerNode) {
                enclosingParent = enclosingParent.getParent();
            }
            if (enclosingBlock instanceof KtBlockExpression && enclosingParent instanceof KtDoWhileExpression && (condition = ((KtDoWhileExpression)enclosingParent).getCondition()) != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{enclosingBlock, condition});
                if (localSearchScope == null) {
                    KtNamedDeclarationStub.$$$reportNull$$$0(5);
                }
                return localSearchScope;
            }
            LocalSearchScope localSearchScope = new LocalSearchScope(enclosingBlock);
            if (localSearchScope == null) {
                KtNamedDeclarationStub.$$$reportNull$$$0(6);
            }
            return localSearchScope;
        }
        PsiElement parent2 = this.getParent();
        PsiElement psiElement = grandParent = parent2 != null ? parent2.getParent() : null;
        if (parent2 instanceof KtBlockExpression && grandParent instanceof KtScript) {
            LocalSearchScope localSearchScope = new LocalSearchScope(this.getContainingFile());
            if (localSearchScope == null) {
                KtNamedDeclarationStub.$$$reportNull$$$0(7);
            }
            return localSearchScope;
        }
        if (this.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            KtElement companionObjectClass;
            KtElement containingClass = PsiTreeUtil.getParentOfType((PsiElement)this, KtClassOrObject.class);
            if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && (companionObjectClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)containingClass, KtClassOrObject.class)) != null) {
                containingClass = companionObjectClass;
            }
            if (containingClass != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope(containingClass);
                if (localSearchScope == null) {
                    KtNamedDeclarationStub.$$$reportNull$$$0(8);
                }
                return localSearchScope;
            }
            KtFile ktFile = this.getContainingKtFile();
            if (this instanceof KtClassOrObject) {
                Project project = this.getProject();
                GlobalSearchScope kotlinFilesScope = GlobalSearchScope.getScopeRestrictedByFileTypes(GlobalSearchScope.allScope(project), KotlinFileType.INSTANCE);
                PsiPackage psiPackage = JavaPsiFacade.getInstance(project).findPackage(ktFile.getPackageFqName().asString());
                SearchScope baseScope = psiPackage != null ? new PackageScope(psiPackage, false, true) : super.getUseScope();
                baseScope.intersectWith(GlobalSearchScope.notScope(kotlinFilesScope));
            } else {
                LocalSearchScope localSearchScope = new LocalSearchScope(ktFile);
                if (localSearchScope == null) {
                    KtNamedDeclarationStub.$$$reportNull$$$0(9);
                }
                return localSearchScope;
            }
        }
        SearchScope scope = super.getUseScope();
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        if (classOrObject != null) {
            scope = scope.intersectWith(classOrObject.getUseScope());
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(10);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return KtNamedDeclarationUtil.getFQName(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtNamedDeclarationStub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtNamedDeclarationStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameAsSafeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

