/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.utils;

import io.vertx.lang.groovy.fastclasspathscanner.utils.FastPathResolver;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtils {
    public static String getCurrDirPathStr() {
        String currDirPathStr = "";
        try {
            Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.normalize();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            currDirPathStr = currDirPath.toString();
            currDirPathStr = FastPathResolver.resolve(currDirPathStr);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not resolve current directory: " + currDirPathStr, e);
        }
        return currDirPathStr;
    }

    public static byte[] readAllBytes(InputStream inputStream, long fileSize, LogNode log) throws IOException {
        int bytesRead;
        if (fileSize > Integer.MAX_VALUE || fileSize < 0L && fileSize != -1L) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(fileSize <= 0L ? 16384 : (int)fileSize);
        byte[] buf = new byte[4096];
        int totBytesRead = 0;
        while ((bytesRead = inputStream.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
            totBytesRead += bytesRead;
        }
        if ((long)totBytesRead != fileSize && log != null) {
            log.log("File length expected to be " + fileSize + " bytes, but read " + totBytesRead + " bytes");
        }
        return baos.toByteArray();
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }
}

