/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;

public abstract class SingletonMap<K, V> {
    private final ConcurrentMap<K, SingletonHolder<V>> map = new ConcurrentHashMap<K, SingletonHolder<V>>();
    private final ConcurrentLinkedQueue<SingletonHolder<V>> singletonHolderRecycler = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSingleton(K key) throws Exception {
        SingletonHolder<V> oldSingletonHolder;
        SingletonHolder<Object> newSingletonHolder = this.singletonHolderRecycler.poll();
        if (newSingletonHolder == null) {
            newSingletonHolder = new SingletonHolder();
        }
        if ((oldSingletonHolder = this.map.putIfAbsent(key, newSingletonHolder)) == null) {
            Object newInstance = null;
            try {
                newInstance = this.newInstance(key);
                if (newInstance == null) {
                    throw new IllegalArgumentException("newInstance(key) returned null");
                }
            }
            finally {
                newSingletonHolder.set(newInstance);
            }
            return true;
        }
        this.singletonHolderRecycler.add(newSingletonHolder);
        return false;
    }

    public V getOrCreateSingleton(K key) throws Exception {
        V existingSingleton = this.get(key);
        if (existingSingleton != null) {
            return existingSingleton;
        }
        this.createSingleton(key);
        return this.get(key);
    }

    public abstract V newInstance(K var1) throws Exception;

    public V get(K key) throws InterruptedException {
        SingletonHolder singletonHolder = (SingletonHolder)this.map.get(key);
        return singletonHolder == null ? null : (V)singletonHolder.get();
    }

    public List<V> values() throws InterruptedException {
        ArrayList entries = new ArrayList(this.map.size());
        for (Map.Entry ent : this.map.entrySet()) {
            entries.add(((SingletonHolder)ent.getValue()).get());
        }
        return entries;
    }

    public void clear() {
        this.map.clear();
    }

    private static class SingletonHolder<V> {
        private V singleton;
        private final CountDownLatch initialized = new CountDownLatch(1);

        private SingletonHolder() {
        }

        public void set(V singleton) {
            this.singleton = singleton;
            this.initialized.countDown();
        }

        public V get() throws InterruptedException {
            this.initialized.await();
            return this.singleton;
        }
    }
}

