require 'vertx-sql-client/row_iterator'
require 'vertx-sql-client/sql_result'
require 'vertx-sql-client/row'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.RowSet
module VertxSqlClient
  #  A set of rows.
  class RowSet < ::VertxSqlClient::SqlResult
    # @private
    # @param j_del [::VertxSqlClient::RowSet] the java delegate
    def initialize(j_del)
      super(j_del, ::VertxSqlClient::RowSet.j_api_type)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::RowSet] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RowSet
    end
    def @@j_api_type.wrap(obj)
      RowSet.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::RowSet.java_class
    end
    #  Get the number of the affected rows in the operation to this PgResult.
    #  <p/>
    #  The meaning depends on the executed statement:
    #  <ul>
    #    <li>INSERT: the number of rows inserted</li>
    #    <li>DELETE: the number of rows deleted</li>
    #    <li>UPDATE: the number of rows updated</li>
    #    <li>SELECT: the number of rows retrieved</li>
    #  </ul>
    # @return [Fixnum] the count of affected rows.
    def row_count
      if !block_given?
        return @j_del.java_method(:rowCount, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling row_count()"
    end
    #  Get the names of columns in the PgResult.
    # @return [Array<String>] the list of names of columns.
    def columns_names
      if !block_given?
        return @j_del.java_method(:columnsNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling columns_names()"
    end
    #  Get the number of rows in the PgResult.
    # @return [Fixnum] the count of rows.
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    #  Get the result value.
    # @return [::VertxSqlClient::RowSet] the result
    def value
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:value, []).call(),::VertxSqlClient::RowSet)
      end
      raise ArgumentError, "Invalid arguments when calling value()"
    end
    # @return [::VertxSqlClient::RowIterator]
    def iterator
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:iterator, []).call(),::VertxSqlClient::RowIterator)
      end
      raise ArgumentError, "Invalid arguments when calling iterator()"
    end
    # @return [::VertxSqlClient::RowSet]
    def next
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:next, []).call(),::VertxSqlClient::RowSet)
      end
      raise ArgumentError, "Invalid arguments when calling next()"
    end
  end
end
