/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-pg-client-js/pg_pool */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var Pool = require('vertx-sql-client-js/pool');
var RowSet = require('vertx-sql-client-js/row_set');
var Tuple = require('vertx-sql-client-js/tuple');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgPool = Java.type('io.vertx.pgclient.PgPool');
var PgConnectOptions = Java.type('io.vertx.pgclient.PgConnectOptions');
var PoolOptions = Java.type('io.vertx.sqlclient.PoolOptions');

/**
 A pool of PostgreSQL connections.

 @class
*/
var PgPool = function(j_val) {

  var j_pgPool = j_val;
  var that = this;
  Pool.call(this, j_val);

  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_preparedQuery = this.preparedQuery;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  /**

   @public
   @param sql {string} 
   @param arguments {Tuple} 
   @param handler {function} 
   @return {PgPool}
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgPool["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_pgPool["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {PgPool}
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgPool["query(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param batch {Array.<Tuple>} 
   @param handler {function} 
   @return {PgPool}
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_pgPool["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0], utils.convParamListVertxGen(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgPool;
};

PgPool._jclass = utils.getJavaClass("io.vertx.pgclient.PgPool");
PgPool._jtype = {accept: function(obj) {
    return PgPool._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgPool.prototype, {});
    PgPool.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgPool._create = function(jdel) {var obj = Object.create(PgPool.prototype, {});
  PgPool.apply(obj, arguments);
  return obj;
}
/**
 Like {@link PgPool#pool} with a specific  instance.

 @memberof module:vertx-pg-client-js/pg_pool
 @param vertx {Vertx} 
 @param connectOptions {Object} 
 @param poolOptions {Object} 
 @return {PgPool}
 */
PgPool.pool =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool()"]()) ;
  } else if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(io.vertx.sqlclient.PoolOptions)"](__args[0]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null)) ;
  } else if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(java.lang.String)"](__args[0])) ;
  } else if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(java.lang.String,io.vertx.sqlclient.PoolOptions)"](__args[0], __args[1]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(io.vertx.core.Vertx,io.vertx.sqlclient.PoolOptions)"](__args[0]._jdel, __args[1]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(io.vertx.core.Vertx,java.lang.String,io.vertx.sqlclient.PoolOptions)"](__args[0]._jdel, __args[1], __args[2]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null)) ;
  } else if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(io.vertx.pgclient.PgConnectOptions,io.vertx.sqlclient.PoolOptions)"](__args[0]  != null ? new PgConnectOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, __args[1]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgPool["pool(io.vertx.core.Vertx,io.vertx.pgclient.PgConnectOptions,io.vertx.sqlclient.PoolOptions)"](__args[0]._jdel, __args[1]  != null ? new PgConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, __args[2]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = PgPool;