/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Launcher;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.spi.launcher.Command;
import io.vertx.core.spi.launcher.ExecutionContext;
import io.vertx.stack.command.ResolveCommand;
import io.vertx.stack.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DescriptorTest {
    private File root = new File("target/stack");

    @Before
    public void setUp() {
        FileUtils.delete(this.root);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> !this.root.exists());
    }

    @Test
    public void testResolutionOfCore() {
        ResolveCommand cmd = new ResolveCommand();
        cmd.setFailOnConflict(false);
        cmd.setDirectory(this.root.getAbsolutePath());
        cmd.setStackDescriptor(new File("src/test/resources/stacks/core.json").getAbsolutePath());
        cmd.setUp(new ExecutionContext((Command)cmd, new VertxCommandLauncher(), null));
        cmd.run();
        Assertions.assertThat((File)new File(this.root, "vertx-core-3.1.0.jar")).isFile();
    }

    @Test
    public void testResolutionOfCoreWithVariable() {
        ResolveCommand cmd = new ResolveCommand();
        cmd.setFailOnConflict(false);
        cmd.setDirectory(this.root.getAbsolutePath());
        cmd.setStackDescriptor(new File("src/test/resources/stacks/core-with-variable.json").getAbsolutePath());
        cmd.setUp(new ExecutionContext((Command)cmd, new VertxCommandLauncher(), null));
        cmd.run();
        Assertions.assertThat((File)new File(this.root, "vertx-core-3.1.0.jar")).isFile();
    }

    @Test
    public void testResolutionOfCoreUsingSystemVariable() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("resolve");
        args.add("--dir=" + this.root.getAbsolutePath());
        args.add("-Dvertx.version=3.1.0");
        args.add(new File("src/test/resources/stacks/core-with-system-variable.json").getAbsolutePath());
        Launcher.main((String[])args.toArray(new String[args.size()]));
        Assertions.assertThat((File)new File(this.root, "vertx-core-3.1.0.jar")).isFile();
    }

    @Test
    public void testResolutionWithDefaultDescriptor() {
        File defaultStack = new File("vertx-stack.json");
        FileUtils.copyFile(new File("src/test/resources/stacks/core-with-system-variable.json"), defaultStack);
        ArrayList<String> args = new ArrayList<String>();
        args.add("resolve");
        args.add("--dir=" + this.root.getAbsolutePath());
        args.add("-Dvertx.version=3.1.0");
        Launcher.main((String[])args.toArray(new String[args.size()]));
        Assertions.assertThat((File)new File(this.root, "vertx-core-3.1.0.jar")).isFile();
        defaultStack.delete();
    }

    @Test
    public void testResolutionWithDefaultDescriptorInVertxHome() {
        File home = new File("target/home");
        home.mkdirs();
        System.setProperty("vertx.home", home.getAbsolutePath());
        FileUtils.copyFile(new File("src/test/resources/stacks/core-with-system-variable.json"), new File(home, "vertx-stack.json"));
        ArrayList<String> args = new ArrayList<String>();
        args.add("resolve");
        args.add("-Dvertx.version=3.1.0");
        Launcher.main((String[])args.toArray(new String[args.size()]));
        Assertions.assertThat((File)new File(home, "lib/vertx-core-3.1.0.jar")).isFile();
        System.clearProperty("vertx.home");
    }
}

