/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.impl.launcher.commands.VersionCommand;
import io.vertx.stack.model.Stack;
import io.vertx.stack.model.StackResolution;
import io.vertx.stack.model.StackResolutionOptions;
import io.vertx.stack.utils.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class VertxStacksTest {
    private static final List<String> BASE = Arrays.asList("io.vertx:vertx-http-service-factory:jar", "io.vertx:vertx-dropwizard-metrics:jar", "io.vertx:vertx-maven-service-factory:jar", "io.vertx:vertx-reactive-streams:jar", "io.vertx:vertx-rx-java:jar", "io.vertx:vertx-rx-groovy:jar", "io.vertx:vertx-rx-js:jar", "io.vertx:vertx-service-factory:jar");
    private File root = new File("target/stack");

    @Before
    public void setUp() {
        FileUtils.delete(this.root);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> !this.root.exists());
        new VersionCommand();
        String vertxVersion = VersionCommand.getVersion();
        Assertions.assertThat((String)vertxVersion).isNotEmpty();
        System.setProperty("vertx.version", vertxVersion);
    }

    @After
    public void tearDown() {
        System.clearProperty("vertx.version");
    }

    @Test
    public void testResolutionOfMinSwitchToBaseAndRevertToMin() {
        Stack stack = Stack.fromDescriptor((File)new File("target/vertx-stack/vertx-stack.json"));
        StackResolution resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true));
        Map resolved = resolution.resolve();
        this.hasKeysStartingBy(resolved, "io.vertx:vertx-core:jar:").ensureThatAllFilesExist(resolved);
        int minArtifacts = resolved.size();
        this.setUpBaseStack(stack);
        resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true));
        resolved = resolution.resolve();
        for (String b : BASE) {
            this.hasKeysStartingBy(resolved, b);
        }
        this.hasKeysStartingBy(resolved, "io.vertx:vertx-core:jar:").ensureThatAllFilesExist(resolved);
        this.tearDownBaseStack(stack);
        resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true));
        resolved = resolution.resolve();
        for (String b : BASE) {
            this.doNotHaveKeysStartingBy(resolved, b);
        }
        this.hasKeysStartingBy(resolved, "io.vertx:vertx-core:jar:").ensureThatAllFilesExist(resolved);
        Assertions.assertThat((int)resolved.size()).isEqualTo(minArtifacts);
    }

    @Test
    public void testConvergence() {
        Stack stack = Stack.fromDescriptor((File)new File("target/vertx-stack/vertx-stack-full.json"));
        stack.getDependencies().stream().forEach(d -> d.setIncluded(true));
        StackResolution resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true).setCacheDisabled(true));
        Map resolved = resolution.resolve();
        Assertions.assertThat((Map)resolved).isNotEmpty();
    }

    @Ignore
    @Test
    public void testScalaConvergence() {
        Stack stack = Stack.fromDescriptor((File)new File("target/vertx-stack/vertx-stack-scala.json"));
        stack.getDependencies().stream().forEach(d -> d.setIncluded(true));
        StackResolution resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true).setCacheDisabled(true));
        Map resolved = resolution.resolve();
        Assertions.assertThat((Map)resolved).isNotEmpty();
    }

    @Test
    public void testTheResolutionOfTheWebStack() {
        Stack stack = Stack.fromDescriptor((File)new File("src/test/resources/stacks/vertx-web-stack.json"));
        StackResolution resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true));
        Map resolved = resolution.resolve();
        Assertions.assertThat((Map)resolved).isNotEmpty();
    }

    @Test
    public void testTheCoreWithoutNettyBufferStack() {
        Stack stack = Stack.fromDescriptor((File)new File("src/test/resources/stacks/vertx-core-only.json"));
        StackResolution resolution = new StackResolution(stack, this.root, new StackResolutionOptions().setFailOnConflicts(true));
        Map resolved = resolution.resolve();
        ((MapAssert)Assertions.assertThat((Map)resolved).isNotEmpty()).doesNotContainKey((Object)"io.netty:netty-buffer");
    }

    private void setUpBaseStack(Stack stack) {
        stack.getDependencies().stream().filter(dependency -> this.wasPartOfTheBaseStack(dependency.getManagementKey())).forEach(dependency -> dependency.setIncluded(true));
    }

    private void tearDownBaseStack(Stack stack) {
        stack.getDependencies().stream().filter(dependency -> this.wasPartOfTheBaseStack(dependency.getManagementKey())).forEach(dependency -> dependency.setIncluded(false));
    }

    private boolean wasPartOfTheBaseStack(String gacv) {
        return BASE.contains(gacv);
    }

    private VertxStacksTest hasKeysStartingBy(Map<String, File> files, String k) {
        if (!this.containsKeyStartingByPrefix(files.keySet(), k)) {
            Assertions.fail((String)("Expected to have a key starting with '" + k + "' in " + files.keySet()));
            return this;
        }
        return this;
    }

    private VertxStacksTest doNotHaveKeysStartingBy(Map<String, File> files, String k) {
        if (this.containsKeyStartingByPrefix(files.keySet(), k)) {
            Assertions.fail((String)("Expected to not have a key starting with '" + k + "' in " + files.keySet()));
            return this;
        }
        return this;
    }

    private VertxStacksTest ensureThatAllFilesExist(Map<String, File> files) {
        for (File f : files.values()) {
            Assertions.assertThat((File)f).isFile();
        }
        return this;
    }

    private boolean containsKeyStartingByPrefix(Set<String> keys, String prefix) {
        for (String k : keys) {
            if (!k.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

