/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.utils;

import io.vertx.stack.resolver.ResolutionOptions;
import io.vertx.stack.utils.Cache;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.junit.Before;
import org.junit.Test;

public class CacheTest {
    private Cache cache;
    private File cacheFile;
    static File TEMP_FILE;

    @Before
    public void setUp() {
        this.cacheFile = new File("target/test-cache/cache.json");
        if (this.cacheFile.isFile()) {
            this.cacheFile.delete();
        }
        this.cache = new Cache(false, false, this.cacheFile);
    }

    @Test
    public void testCachingOfReleaseAndUpdate() throws IOException {
        String gacv = "org.acme:acme:jar:1.0";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0").setFile(TEMP_FILE);
        Artifact artifact2 = new DefaultArtifact("org.acme:acme-dep:jar:1.0").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        this.cache.put(gacv, options, Arrays.asList(artifact, artifact2));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(2);
    }

    @Test
    public void testCachingOfSnapshotAndUpdate() throws IOException {
        String gacv = "org.acme:acme:jar:1.0-SNAPSHOT";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0-SNAPSHOT").setFile(TEMP_FILE);
        Artifact artifact2 = new DefaultArtifact("org.acme:acme-dep:jar:1.0-SNAPSHOT").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        this.cache.put(gacv, options, Arrays.asList(artifact, artifact2));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(2);
    }

    @Test
    public void testDisabledCache() throws IOException {
        String gacv = "org.acme:acme:jar:1.0";
        this.cache = new Cache(true, false, this.cacheFile);
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        File file = File.createTempFile("acme", ".jar");
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0").setFile(file);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
    }

    @Test
    public void testCacheDisabledForSnapshots() throws IOException {
        String gacv = "org.acme:acme:jar:1.0-SNAPSHOT";
        this.cache = new Cache(false, true, this.cacheFile);
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0-SNAPSHOT").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
    }

    @Test
    public void testWithInvalidArtifact() throws IOException {
        String gacv = "org.acme:acme:jar:1.0";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0").setFile(new File("does not exist.jar"));
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
    }

    @Test
    public void testWithEmptyResolution() throws IOException {
        String gacv = "org.acme:acme:jar:1.0";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        this.cache.put(gacv, options, Collections.emptyList());
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
    }

    @Test
    public void testCacheReloading() throws IOException {
        String gacv = "org.acme:acme:jar:1.0";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        this.cache.writeCacheOnFile();
        this.cache = new Cache(false, false, this.cacheFile);
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
    }

    @Test
    public void testSnapshotEviction() throws IOException {
        String gacv = "org.acme:acme:jar:1.0-SNAPSHOT";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0-SNAPSHOT").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        Optional entry = this.cache.find(gacv, options);
        ((Cache.CacheEntry)entry.get()).setInsertionTime(System.currentTimeMillis() - 90000000L);
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
    }

    @Test
    public void testNonSnapshotEviction() throws IOException {
        String gacv = "org.acme:acme:jar:1.0-SNAPSHOT";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0-SNAPSHOT").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        Optional entry = this.cache.find(gacv, options);
        ((Cache.CacheEntry)entry.get()).setInsertionTime(System.currentTimeMillis() - 79200000L);
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
    }

    @Test
    public void testCachingUsingDifferentResolutionOption() throws IOException {
        String gacv = "org.acme:acme:jar:1.0";
        ResolutionOptions options = new ResolutionOptions();
        List list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        Artifact artifact = new DefaultArtifact("org.acme:acme:jar:1.0").setFile(TEMP_FILE);
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        options = new ResolutionOptions().setWithTransitive(false);
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((int)this.cache.size()).isEqualTo(2);
        options = new ResolutionOptions().setWithTransitive(true).addExclusion("org.acme:transitive");
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).isNull();
        this.cache.put(gacv, options, Collections.singletonList(artifact));
        list = this.cache.get(gacv, options);
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((int)this.cache.size()).isEqualTo(3);
    }

    static {
        try {
            TEMP_FILE = File.createTempFile("acme", ".jar");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

