/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.utils;

import io.vertx.stack.utils.Filtering;
import io.vertx.stack.utils.FluentMap;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.Test;

public class FilteringTest {
    @Test
    public void testFilteringWithoutVariables() {
        String out = Filtering.filter((String)"hello", Collections.emptyMap());
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello");
    }

    @Test
    public void testFilteringWithoutPlaceholders() {
        String out = Filtering.filter((String)"hello", (Map)new FluentMap<String, String>().add("key", "value"));
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello");
    }

    @Test
    public void testFilteringWithNonMatchingVariables() {
        String out = Filtering.filter((String)"hello ${nope}", (Map)new FluentMap<String, String>().add("key", "value"));
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello ${nope}");
    }

    @Test
    public void testFilteringWithReplacement() {
        String out = Filtering.filter((String)"hello ${world}", (Map)new FluentMap<String, String>().add("world", "vert.x"));
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello vert.x");
    }

    @Test
    public void testFilteringWithPartialReplacement() {
        String out = Filtering.filter((String)"hello ${world} ${period}", (Map)new FluentMap<String, String>().add("world", "vert.x"));
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello vert.x ${period}");
    }

    @Test
    public void testFilteringWithNestedReplacement() {
        String out = Filtering.filter((String)"hello ${world} ${period}", (Map)new FluentMap<String, String>().add("name", "vert.x").add("world", "${name}"));
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello vert.x ${period}");
    }

    @Test
    public void testFilteringWithUnfinishedVariables() {
        String out = Filtering.filter((String)"hello ${world} ${per ", (Map)new FluentMap<String, String>().add("name", "vert.x").add("world", "${name}"));
        AssertionsForInterfaceTypes.assertThat((String)out).isEqualTo((Object)"hello vert.x ${per ");
    }
}

