/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.utils;

import io.vertx.stack.utils.FileUtils;
import io.vertx.stack.utils.LocalDependency;
import io.vertx.stack.utils.PomUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocalArtifact {
    public static final String MAIN_ARTIFACT_CLASSIFIER = "MAIN";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private String packaging;
    private Map<String, File> files = new HashMap<String, File>();
    private LocalArtifact parent;
    private List<LocalDependency> dependencies = new ArrayList<LocalDependency>();
    private List<LocalDependency> dependencyManagement = new ArrayList<LocalDependency>();
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private boolean inheritGroupId;
    private boolean inheritVersion;

    public LocalArtifact(String groupId, String artifactId, String version) {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public LocalArtifact inheritGroupId() {
        this.inheritGroupId = true;
        return this;
    }

    public LocalArtifact inheritVersion() {
        this.inheritVersion = true;
        return this;
    }

    public LocalArtifact packaging(String type) {
        this.packaging = type;
        return this;
    }

    public LocalArtifact file(File file) {
        this.files.put(MAIN_ARTIFACT_CLASSIFIER, file);
        return this;
    }

    public LocalArtifact file(File file, String classifier) {
        this.files.put(classifier, file);
        return this;
    }

    public LocalArtifact parent(LocalArtifact parent) {
        this.parent = parent;
        return this;
    }

    public LocalArtifact parent(String groupId, String artifactId, String version) {
        this.parent = new LocalArtifact(groupId, artifactId, version);
        return this;
    }

    public LocalArtifact addDependency(LocalDependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public LocalArtifact addDependencyToDependencyManagement(LocalDependency dependency) {
        this.dependencyManagement.add(dependency);
        return this;
    }

    public LocalArtifact addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public File getArtifactDirectory(File root) {
        return new File(root, this.groupId.replace(".", File.separator) + File.separator + this.artifactId + File.separator + this.version);
    }

    public File getPomFile(File root) {
        return new File(this.getArtifactDirectory(root), this.artifactId + "-" + this.version + ".pom");
    }

    public File getFile(File root) {
        String ext = FileUtils.getExtension(this.files.get(MAIN_ARTIFACT_CLASSIFIER));
        return new File(this.getArtifactDirectory(root), this.artifactId + "-" + this.version + "." + ext);
    }

    public File getFile(String classifier, File root) {
        String ext = FileUtils.getExtension(this.files.get(classifier));
        return new File(this.getArtifactDirectory(root), this.artifactId + "-" + this.version + "-" + classifier + "." + ext);
    }

    public String toPom() {
        StringBuilder builder = new StringBuilder();
        this.line(builder, 0, "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0\n                      http://maven.apache.org/xsd/maven-4.0.0.xsd\">");
        this.line(builder, 1, "<modelVersion>4.0.0</modelVersion>");
        if (!this.inheritGroupId) {
            this.line(builder, 1, "<groupId>" + this.groupId + "</groupId>");
        }
        this.line(builder, 1, "<artifactId>" + this.artifactId + "</artifactId>");
        if (!this.inheritVersion) {
            this.line(builder, 1, "<version>" + this.version + "</version>");
        }
        if (this.parent != null) {
            this.line(builder, 1, "<parent>");
            this.line(builder, 2, "<groupId>" + this.parent.groupId + "</groupId>");
            this.line(builder, 2, "<artifactId>" + this.parent.artifactId + "</artifactId>");
            this.line(builder, 2, "<version>" + this.parent.version + "</version>");
            this.line(builder, 1, "</parent>");
        }
        if (this.packaging != null) {
            this.line(builder, 1, "<packaging>" + this.packaging + "</packaging>");
        }
        if (!this.properties.isEmpty()) {
            this.line(builder, 1, "<properties>");
            this.properties.forEach((k, v) -> this.line(builder, 2, "<" + k + ">" + v + "</" + k + ">"));
            this.line(builder, 1, "</properties>");
        }
        if (!this.dependencyManagement.isEmpty()) {
            this.line(builder, 1, "<dependencyManagement>");
            this.dependencyManagement.stream().forEach(dep -> builder.append(dep.toDependency(2)));
            this.line(builder, 1, "</dependencyManagement>");
        }
        if (!this.dependencies.isEmpty()) {
            this.line(builder, 1, "<dependencies>");
            this.dependencies.stream().forEach(dep -> builder.append(dep.toDependency(2)));
            this.line(builder, 1, "</dependencies>");
        }
        this.line(builder, 0, "</project>");
        return builder.toString();
    }

    private void line(StringBuilder builder, int indent, String line) {
        builder.append(PomUtils.indentation(indent)).append(line).append("\n");
    }

    public Map<String, File> getFiles() {
        return this.files;
    }

    public String gav() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public LocalArtifact generateMainArtifact() {
        try {
            File tmp = File.createTempFile("local-artifact-" + this.artifactId, ".txt");
            FileUtils.write(tmp, this.gav());
            return this.file(tmp).packaging("txt");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

