/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.utils;

import io.vertx.stack.utils.PomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LocalDependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private String type;
    private List<Exclusion> exclusions = new ArrayList<Exclusion>();
    private String scope = "compile";
    private boolean optional = false;
    private String classifier;

    public LocalDependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        this.version = version;
    }

    public LocalDependency(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public LocalDependency type(String type) {
        this.type = type;
        return this;
    }

    public LocalDependency classifier(String c) {
        this.classifier = c;
        return this;
    }

    public LocalDependency optional(boolean opt) {
        this.optional = opt;
        return this;
    }

    public LocalDependency scope(String scope) {
        this.scope = scope;
        return this;
    }

    public LocalDependency addExclusion(String groupId, String artifactId) {
        this.exclusions.add(new Exclusion(groupId, artifactId));
        return this;
    }

    public String toDependency(int indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(PomUtils.indentation(indent)).append("<dependency>\n");
        builder.append(PomUtils.indentation(indent + 1)).append("<groupId>").append(this.groupId).append("</groupId>\n");
        builder.append(PomUtils.indentation(indent + 1)).append("<artifactId>").append(this.artifactId).append("</artifactId>\n");
        if (this.version != null) {
            builder.append(PomUtils.indentation(indent + 1)).append("<version>").append(this.version).append("</version>\n");
        }
        if (this.optional) {
            builder.append(PomUtils.indentation(indent + 1)).append("<optional>true</optional>\n");
        }
        if (this.type != null) {
            builder.append(PomUtils.indentation(indent + 1)).append("<type>").append(this.type).append("</type>\n");
        }
        if (this.scope != null) {
            builder.append(PomUtils.indentation(indent + 1)).append("<scope>").append(this.scope).append("</scope>\n");
        }
        if (this.classifier != null) {
            builder.append(PomUtils.indentation(indent + 1)).append("<classifier>").append(this.classifier).append("</classifier>\n");
        }
        if (!this.exclusions.isEmpty()) {
            builder.append(PomUtils.indentation(indent + 1)).append("<exclusions>\n");
            for (Exclusion exclusion : this.exclusions) {
                builder.append(PomUtils.indentation(indent + 2)).append("<exclusion>\n");
                builder.append(PomUtils.indentation(indent + 3)).append("<groupId>").append(exclusion.groupId).append("</groupId>\n");
                builder.append(PomUtils.indentation(indent + 3)).append("<artifactId>").append(exclusion.artifactId).append("</artifactId>\n");
                builder.append(PomUtils.indentation(indent + 2)).append("</exclusion>\n");
            }
            builder.append(PomUtils.indentation(indent + 1)).append("</exclusions>\n");
        }
        builder.append(PomUtils.indentation(indent)).append("</dependency>\n");
        return builder.toString();
    }

    private class Exclusion {
        private final String groupId;
        private final String artifactId;

        public Exclusion(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }
    }
}

