/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.MergedField;
import graphql.execution.directives.DirectivesResolver;
import graphql.execution.directives.QueryAppliedDirective;
import graphql.execution.directives.QueryAppliedDirectiveArgument;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class QueryDirectivesImpl
implements QueryDirectives {
    private final DirectivesResolver directivesResolver = new DirectivesResolver();
    private final MergedField mergedField;
    private final GraphQLSchema schema;
    private final Map<String, Object> variables;
    private volatile ImmutableMap<Field, List<GraphQLDirective>> fieldDirectivesByField;
    private volatile ImmutableMap<String, List<GraphQLDirective>> fieldDirectivesByName;
    private volatile ImmutableMap<Field, List<QueryAppliedDirective>> fieldAppliedDirectivesByField;
    private volatile ImmutableMap<String, List<QueryAppliedDirective>> fieldAppliedDirectivesByName;

    public QueryDirectivesImpl(MergedField mergedField, GraphQLSchema schema, Map<String, Object> variables) {
        this.mergedField = mergedField;
        this.schema = schema;
        this.variables = variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeValuesLazily() {
        QueryDirectivesImpl queryDirectivesImpl = this;
        synchronized (queryDirectivesImpl) {
            if (this.fieldDirectivesByField != null) {
                return;
            }
            LinkedHashMap<Field, List> byField = new LinkedHashMap<Field, List>();
            LinkedHashMap byFieldApplied = new LinkedHashMap();
            this.mergedField.getFields().forEach(field -> {
                List<Directive> directives = field.getDirectives();
                ImmutableList<GraphQLDirective> resolvedDirectives = ImmutableList.copyOf(this.directivesResolver.resolveDirectives(directives, this.schema, this.variables).values());
                byField.put((Field)field, resolvedDirectives);
                byFieldApplied.put(field, ImmutableKit.map(resolvedDirectives, this::toAppliedDirective));
            });
            LinkedHashMap byName = new LinkedHashMap();
            LinkedHashMap byNameApplied = new LinkedHashMap();
            byField.forEach((field, directiveList) -> directiveList.forEach(directive -> {
                String name = directive.getName();
                byName.computeIfAbsent(name, k -> new ArrayList()).add(directive);
                byNameApplied.computeIfAbsent(name, k -> new ArrayList()).add(this.toAppliedDirective((GraphQLDirective)directive));
            }));
            this.fieldDirectivesByName = ImmutableMap.copyOf(byName);
            this.fieldDirectivesByField = ImmutableMap.copyOf(byField);
            this.fieldAppliedDirectivesByName = ImmutableMap.copyOf(byNameApplied);
            this.fieldAppliedDirectivesByField = ImmutableMap.copyOf(byFieldApplied);
        }
    }

    private QueryAppliedDirective toAppliedDirective(GraphQLDirective directive) {
        QueryAppliedDirective.Builder builder = QueryAppliedDirective.newDirective();
        builder.name(directive.getName());
        for (GraphQLArgument argument : directive.getArguments()) {
            builder.argument(this.toAppliedArgument(argument));
        }
        return builder.build();
    }

    private QueryAppliedDirectiveArgument toAppliedArgument(GraphQLArgument argument) {
        return ((QueryAppliedDirectiveArgument.Builder)QueryAppliedDirectiveArgument.newArgument().name(argument.getName())).type(argument.getType()).inputValueWithState(argument.getArgumentValue()).build();
    }

    @Override
    public Map<Field, List<GraphQLDirective>> getImmediateDirectivesByField() {
        this.computeValuesLazily();
        return this.fieldDirectivesByField;
    }

    @Override
    public Map<Field, List<QueryAppliedDirective>> getImmediateAppliedDirectivesByField() {
        this.computeValuesLazily();
        return this.fieldAppliedDirectivesByField;
    }

    @Override
    public Map<String, List<GraphQLDirective>> getImmediateDirectivesByName() {
        this.computeValuesLazily();
        return this.fieldDirectivesByName;
    }

    @Override
    public Map<String, List<QueryAppliedDirective>> getImmediateAppliedDirectivesByName() {
        this.computeValuesLazily();
        return this.fieldAppliedDirectivesByName;
    }

    @Override
    public List<GraphQLDirective> getImmediateDirective(String directiveName) {
        this.computeValuesLazily();
        return this.getImmediateDirectivesByName().getOrDefault(directiveName, Collections.emptyList());
    }

    @Override
    public List<QueryAppliedDirective> getImmediateAppliedDirective(String directiveName) {
        this.computeValuesLazily();
        return this.getImmediateAppliedDirectivesByName().getOrDefault(directiveName, Collections.emptyList());
    }
}

