/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Internal;
import graphql.language.VariableDefinition;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.ValueToVariableValueCompiler;
import graphql.normalized.VariablePredicate;
import graphql.normalized.VariableValueWithDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@Internal
public class VariableAccumulator {
    private final List<VariableValueWithDefinition> valueWithDefinitions;
    @Nullable
    private final VariablePredicate variablePredicate;

    public VariableAccumulator(@Nullable VariablePredicate variablePredicate) {
        this.variablePredicate = variablePredicate;
        this.valueWithDefinitions = new ArrayList<VariableValueWithDefinition>();
    }

    public boolean shouldMakeVariable(ExecutableNormalizedField executableNormalizedField, String argName, NormalizedInputValue normalizedInputValue) {
        return this.variablePredicate != null && this.variablePredicate.shouldMakeVariable(executableNormalizedField, argName, normalizedInputValue);
    }

    public VariableValueWithDefinition accumulateVariable(NormalizedInputValue normalizedInputValue) {
        VariableValueWithDefinition variableWithDefinition = ValueToVariableValueCompiler.normalizedInputValueToVariable(normalizedInputValue, this.getAccumulatedSize());
        this.valueWithDefinitions.add(variableWithDefinition);
        return variableWithDefinition;
    }

    public int getAccumulatedSize() {
        return this.valueWithDefinitions.size();
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.valueWithDefinitions.stream().map(VariableValueWithDefinition::getDefinition).collect(Collectors.toList());
    }

    public Map<String, Object> getVariablesMap() {
        return this.valueWithDefinitions.stream().collect(Collectors.toMap(variableWithDefinition -> variableWithDefinition.getDefinition().getName(), VariableValueWithDefinition::getValue));
    }
}

