/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.PublicApi;
import graphql.parser.ParsingListener;
import java.util.function.Consumer;

@PublicApi
public class ParserOptions {
    public static final int MAX_QUERY_TOKENS = 15000;
    private static ParserOptions defaultJvmParserOptions = ParserOptions.newParserOptions().captureIgnoredChars(false).captureSourceLocation(true).captureLineComments(true).maxTokens(15000).build();
    private final boolean captureIgnoredChars;
    private final boolean captureSourceLocation;
    private final boolean captureLineComments;
    private final int maxTokens;
    private final ParsingListener parsingListener;

    public static ParserOptions getDefaultParserOptions() {
        return defaultJvmParserOptions;
    }

    public static void setDefaultParserOptions(ParserOptions options) {
        defaultJvmParserOptions = Assert.assertNotNull(options);
    }

    private ParserOptions(Builder builder) {
        this.captureIgnoredChars = builder.captureIgnoredChars;
        this.captureSourceLocation = builder.captureSourceLocation;
        this.captureLineComments = builder.captureLineComments;
        this.maxTokens = builder.maxTokens;
        this.parsingListener = builder.parsingListener;
    }

    public boolean isCaptureIgnoredChars() {
        return this.captureIgnoredChars;
    }

    public boolean isCaptureSourceLocation() {
        return this.captureSourceLocation;
    }

    public boolean isCaptureLineComments() {
        return this.captureLineComments;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public ParsingListener getParsingListener() {
        return this.parsingListener;
    }

    public ParserOptions transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newParserOptions() {
        return new Builder();
    }

    public static class Builder {
        private boolean captureIgnoredChars = false;
        private boolean captureSourceLocation = true;
        private boolean captureLineComments = true;
        private int maxTokens = 15000;
        private ParsingListener parsingListener = ParsingListener.NOOP;

        Builder() {
        }

        Builder(ParserOptions parserOptions) {
            this.captureIgnoredChars = parserOptions.captureIgnoredChars;
            this.captureSourceLocation = parserOptions.captureSourceLocation;
            this.captureLineComments = parserOptions.captureLineComments;
            this.maxTokens = parserOptions.maxTokens;
            this.parsingListener = parserOptions.parsingListener;
        }

        public Builder captureIgnoredChars(boolean captureIgnoredChars) {
            this.captureIgnoredChars = captureIgnoredChars;
            return this;
        }

        public Builder captureSourceLocation(boolean captureSourceLocation) {
            this.captureSourceLocation = captureSourceLocation;
            return this;
        }

        public Builder captureLineComments(boolean captureLineComments) {
            this.captureLineComments = captureLineComments;
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder parsingListener(ParsingListener parsingListener) {
            this.parsingListener = Assert.assertNotNull(parsingListener);
            return this;
        }

        public ParserOptions build() {
            return new ParserOptions(this);
        }
    }
}

