/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.AssertException;
import graphql.Directives;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.TypeResolverProxy;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaGeneratorAppliedDirectiveHelper;
import graphql.schema.idl.SchemaGeneratorDirectiveHelper;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.schema.idl.errors.NotAnOutputTypeError;
import graphql.util.FpKit;
import graphql.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class SchemaGeneratorHelper {
    static final String NO_LONGER_SUPPORTED = "No longer supported";

    static String buildDescription(BuildContext buildContext, Node<?> node, Description description) {
        if (description != null) {
            return description.getContent();
        }
        if (!buildContext.options.isUseCommentsAsDescription()) {
            return null;
        }
        List<Comment> comments = node.getComments();
        ArrayList<String> lines = new ArrayList<String>();
        for (Comment comment : comments) {
            String commentLine = comment.getContent();
            if (commentLine.trim().isEmpty()) {
                lines.clear();
                continue;
            }
            lines.add(commentLine);
        }
        if (lines.size() == 0) {
            return null;
        }
        return String.join((CharSequence)"\n", lines);
    }

    String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = Optional.ofNullable(directives).orElse(Collections.emptyList())).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return NO_LONGER_SUPPORTED;
            }
            return args.get("reason");
        }
        return null;
    }

    public Function<Type<?>, GraphQLInputType> inputTypeFactory(BuildContext buildCtx) {
        return rawType -> this.buildInputType(buildCtx, (Type)rawType);
    }

    GraphQLInputType buildInputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition<?> typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLInputType inputType = buildCtx.hasInputType(typeDefinition);
        if (inputType != null) {
            return (GraphQLInputType)typeInfo.decorate(inputType);
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (GraphQLInputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName()));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof InputObjectTypeDefinition) {
            inputType = this.buildInputObjectType(buildCtx, (InputObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            inputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            inputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnInputTypeError(rawType, typeDefinition);
        }
        buildCtx.putInputType((GraphQLNamedInputType)inputType);
        buildCtx.pop();
        return (GraphQLInputType)typeInfo.decorate(inputType);
    }

    GraphQLInputObjectType buildInputObjectType(BuildContext buildCtx, InputObjectTypeDefinition typeDefinition) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InputObjectTypeExtensionDefinition> extensions = this.inputObjectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.INPUT_OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        typeDefinition.getInputValueDefinitions().forEach(inputValue -> builder.field(this.buildInputField(buildCtx, (InputValueDefinition)inputValue)));
        extensions.forEach(extension -> extension.getInputValueDefinitions().forEach(inputValueDefinition -> {
            GraphQLInputObjectField inputField = this.buildInputField(buildCtx, (InputValueDefinition)inputValueDefinition);
            if (!builder.hasField(inputField.getName())) {
                builder.field(inputField);
            }
        }));
        return this.directivesObserve(buildCtx, builder.build());
    }

    private GraphQLInputObjectField buildInputField(BuildContext buildCtx, InputValueDefinition fieldDef) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        fieldBuilder.definition(buildCtx.isCaptureAstDefinitions() ? fieldDef : null);
        fieldBuilder.name(fieldDef.getName());
        fieldBuilder.description(SchemaGeneratorHelper.buildDescription(buildCtx, fieldDef, fieldDef.getDescription()));
        fieldBuilder.deprecate(this.buildDeprecationReason(fieldDef.getDirectives()));
        fieldBuilder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, fieldDef.getType());
        fieldBuilder.type(inputType);
        Value defaultValue = fieldDef.getDefaultValue();
        if (defaultValue != null) {
            fieldBuilder.defaultValueLiteral(defaultValue);
        }
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, fieldBuilder, appliedDirectives);
        return this.directivesObserve(buildCtx, fieldBuilder.build());
    }

    GraphQLEnumType buildEnumType(BuildContext buildCtx, EnumTypeDefinition typeDefinition) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<EnumTypeExtensionDefinition> extensions = this.enumTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        EnumValuesProvider enumValuesProvider = buildCtx.getWiring().getEnumValuesProviders().get(typeDefinition.getName());
        typeDefinition.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            builder.value(enumValueDefinition);
        });
        extensions.forEach(extension -> extension.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            if (!builder.hasValue(enumValueDefinition.getName())) {
                builder.value(enumValueDefinition);
            }
        }));
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.ENUM, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        return this.directivesObserve(buildCtx, builder.build());
    }

    private GraphQLEnumValueDefinition buildEnumValue(BuildContext buildCtx, EnumTypeDefinition typeDefinition, EnumValuesProvider enumValuesProvider, EnumValueDefinition evd) {
        Object value;
        String description = SchemaGeneratorHelper.buildDescription(buildCtx, evd, evd.getDescription());
        String deprecation = this.buildDeprecationReason(evd.getDirectives());
        if (enumValuesProvider != null) {
            value = enumValuesProvider.getValue(evd.getName());
            Assert.assertNotNull(value, () -> String.format("EnumValuesProvider for %s returned null for %s", typeDefinition.getName(), evd.getName()));
        } else {
            value = evd.getName();
        }
        GraphQLEnumValueDefinition.Builder builder = (GraphQLEnumValueDefinition.Builder)GraphQLEnumValueDefinition.newEnumValueDefinition().name(evd.getName()).value(value).description(description).deprecationReason(deprecation).definition(buildCtx.isCaptureAstDefinitions() ? evd : null).comparatorRegistry(buildCtx.getComparatorRegistry());
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), evd.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ENUM_VALUE, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        GraphQLEnumValueDefinition enumValueDefinition = builder.build();
        return this.directivesObserve(buildCtx, enumValueDefinition);
    }

    GraphQLScalarType buildScalar(BuildContext buildCtx, ScalarTypeDefinition typeDefinition) {
        List<ScalarTypeExtensionDefinition> extensions;
        ScalarWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        GraphQLScalarType scalar = wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, typeDefinition, extensions = this.scalarTypeExtensions(typeDefinition, buildCtx))) ? wiringFactory.getScalar(environment) : buildCtx.getWiring().getScalars().get(typeDefinition.getName());
        if (!ScalarInfo.isGraphqlSpecifiedScalar(scalar)) {
            String description = this.getScalarDesc(scalar, typeDefinition);
            Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.SCALAR, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
            scalar = scalar.transform(builder -> {
                ((GraphQLScalarType.Builder)builder.description(description).definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null).comparatorRegistry(buildCtx.getComparatorRegistry())).specifiedByUrl(this.getSpecifiedByUrl(typeDefinition, extensions));
                SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
            });
        }
        return this.directivesObserve(buildCtx, scalar);
    }

    private String getScalarDesc(GraphQLScalarType scalar, ScalarTypeDefinition typeDefinition) {
        if (scalar.getDescription() != null && !scalar.getDescription().trim().isEmpty()) {
            return scalar.getDescription();
        }
        if (typeDefinition.getDescription() != null) {
            return typeDefinition.getDescription().getContent();
        }
        return "";
    }

    String getSpecifiedByUrl(ScalarTypeDefinition scalarTypeDefinition, List<ScalarTypeExtensionDefinition> extensions) {
        ArrayList<Directive> allDirectives = new ArrayList<Directive>(scalarTypeDefinition.getDirectives());
        extensions.forEach(extension -> allDirectives.addAll(extension.getDirectives()));
        Optional<Directive> specifiedByDirective = FpKit.findOne(allDirectives, directiveDefinition -> directiveDefinition.getName().equals(Directives.SpecifiedByDirective.getName()));
        if (!specifiedByDirective.isPresent()) {
            return null;
        }
        Argument urlArgument = specifiedByDirective.get().getArgument("url");
        StringValue url = (StringValue)urlArgument.getValue();
        return url.getValue();
    }

    private TypeResolver getTypeResolverForInterface(BuildContext buildCtx, InterfaceTypeDefinition interfaceType) {
        TypeResolver typeResolver;
        InterfaceWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new InterfaceWiringEnvironment(typeRegistry, interfaceType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, () -> "The WiringFactory indicated it provides a interface type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(interfaceType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private TypeResolver getTypeResolverForUnion(BuildContext buildCtx, UnionTypeDefinition unionType) {
        TypeResolver typeResolver;
        UnionWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new UnionWiringEnvironment(typeRegistry, unionType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, () -> "The WiringFactory indicated it union provides a type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(unionType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private void buildInterfaceTypeInterfaces(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition, GraphQLInterfaceType.Builder builder, List<InterfaceTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type<?>)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type<?>)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    private GraphQLObjectType buildOperation(BuildContext buildCtx, OperationTypeDefinition operation) {
        return (GraphQLObjectType)this.buildOutputType(buildCtx, operation.getTypeName());
    }

    GraphQLInterfaceType buildInterfaceType(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition) {
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InterfaceTypeExtensionDefinition> extensions = this.interfaceTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildInterfaceTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        GraphQLInterfaceType interfaceType = builder.build();
        if (!buildCtx.getCodeRegistry().hasTypeResolver(interfaceType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForInterface(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(interfaceType, typeResolver);
        }
        return this.directivesObserve(buildCtx, interfaceType);
    }

    GraphQLObjectType buildObjectType(BuildContext buildCtx, ObjectTypeDefinition typeDefinition) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<ObjectTypeExtensionDefinition> extensions = this.objectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildObjectTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        return this.directivesObserve(buildCtx, builder.build());
    }

    private void buildObjectTypeInterfaces(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<ObjectTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type<?>)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type<?>)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    GraphQLUnionType buildUnionType(BuildContext buildCtx, UnionTypeDefinition typeDefinition) {
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? typeDefinition : null);
        builder.name(typeDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<UnionTypeExtensionDefinition> extensions = this.unionTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? extensions : Collections.emptyList());
        typeDefinition.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type<?>)mt);
            if (outputType instanceof GraphQLTypeReference) {
                builder.possibleType((GraphQLTypeReference)outputType);
            } else {
                builder.possibleType((GraphQLObjectType)outputType);
            }
        });
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.UNION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        extensions.forEach(extension -> extension.getMemberTypes().forEach(mt -> {
            GraphQLNamedOutputType outputType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type<?>)mt);
            if (!builder.containType(outputType.getName())) {
                if (outputType instanceof GraphQLTypeReference) {
                    builder.possibleType((GraphQLTypeReference)outputType);
                } else {
                    builder.possibleType((GraphQLObjectType)outputType);
                }
            }
        }));
        GraphQLUnionType unionType = builder.build();
        if (!buildCtx.getCodeRegistry().hasTypeResolver(unionType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForUnion(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(unionType, typeResolver);
        }
        return this.directivesObserve(buildCtx, unionType);
    }

    private <T extends GraphQLOutputType> T buildOutputType(BuildContext buildCtx, Type<?> rawType) {
        TypeDefinition<?> typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLOutputType outputType = buildCtx.hasOutputType(typeDefinition);
        if (outputType != null) {
            return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (T)((GraphQLOutputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName())));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof ObjectTypeDefinition) {
            outputType = this.buildObjectType(buildCtx, (ObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof InterfaceTypeDefinition) {
            outputType = this.buildInterfaceType(buildCtx, (InterfaceTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof UnionTypeDefinition) {
            outputType = this.buildUnionType(buildCtx, (UnionTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            outputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            outputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnOutputTypeError(rawType, typeDefinition);
        }
        buildCtx.putOutputType((GraphQLNamedOutputType)outputType);
        buildCtx.pop();
        return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
    }

    GraphQLFieldDefinition buildField(BuildContext buildCtx, TypeDefinition<?> parentType, FieldDefinition fieldDef) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? fieldDef : null);
        builder.name(fieldDef.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, fieldDef, fieldDef.getDescription()));
        builder.deprecate(this.buildDeprecationReason(fieldDef.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.FIELD_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        fieldDef.getInputValueDefinitions().forEach(inputValueDefinition -> builder.argument(this.buildArgument(buildCtx, (InputValueDefinition)inputValueDefinition)));
        Object fieldType = this.buildOutputType(buildCtx, fieldDef.getType());
        builder.type((GraphQLOutputType)fieldType);
        GraphQLFieldDefinition fieldDefinition = builder.build();
        FieldCoordinates coordinates = FieldCoordinates.coordinates(parentType.getName(), fieldDefinition.getName());
        if (!buildCtx.getCodeRegistry().hasDataFetcher(coordinates)) {
            DataFetcherFactory<?> dataFetcherFactory = this.buildDataFetcherFactory(buildCtx, parentType, fieldDef, (GraphQLOutputType)fieldType, (List)appliedDirectives.first, (List)appliedDirectives.second);
            buildCtx.getCodeRegistry().dataFetcher(coordinates, dataFetcherFactory);
        }
        return this.directivesObserve(buildCtx, fieldDefinition);
    }

    private DataFetcherFactory<?> buildDataFetcherFactory(BuildContext buildCtx, TypeDefinition<?> parentType, FieldDefinition fieldDef, GraphQLOutputType fieldType, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives) {
        DataFetcherFactory dataFetcherFactory;
        String fieldName = fieldDef.getName();
        String parentTypeName = parentType.getName();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        GraphQLCodeRegistry.Builder codeRegistry = buildCtx.getCodeRegistry();
        FieldWiringEnvironment wiringEnvironment = new FieldWiringEnvironment(typeRegistry, parentType, fieldDef, fieldType, directives, appliedDirectives);
        if (wiringFactory.providesDataFetcherFactory(wiringEnvironment)) {
            dataFetcherFactory = wiringFactory.getDataFetcherFactory(wiringEnvironment);
            Assert.assertNotNull(dataFetcherFactory, () -> "The WiringFactory indicated it provides a data fetcher factory but then returned null");
        } else {
            DataFetcher dataFetcher;
            if (wiringFactory.providesDataFetcher(wiringEnvironment)) {
                dataFetcher = wiringFactory.getDataFetcher(wiringEnvironment);
                Assert.assertNotNull(dataFetcher, () -> "The WiringFactory indicated it provides a data fetcher but then returned null");
            } else {
                dataFetcher = runtimeWiring.getDataFetcherForType(parentTypeName).get(fieldName);
                if (dataFetcher == null && (dataFetcher = runtimeWiring.getDefaultDataFetcherForType(parentTypeName)) == null && (dataFetcher = wiringFactory.getDefaultDataFetcher(wiringEnvironment)) == null) {
                    DataFetcherFactory<?> codeRegistryDFF = codeRegistry.getDefaultDataFetcherFactory();
                    if (codeRegistryDFF != null) {
                        return codeRegistryDFF;
                    }
                    dataFetcher = this.dataFetcherOfLastResort(wiringEnvironment);
                }
            }
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
        }
        return dataFetcherFactory;
    }

    GraphQLArgument buildArgument(BuildContext buildCtx, InputValueDefinition valueDefinition) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? valueDefinition : null);
        builder.name(valueDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, valueDefinition, valueDefinition.getDescription()));
        builder.deprecate(this.buildDeprecationReason(valueDefinition.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, valueDefinition.getType());
        builder.type(inputType);
        Value defaultValue = valueDefinition.getDefaultValue();
        if (defaultValue != null) {
            builder.defaultValueLiteral(defaultValue);
        }
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), valueDefinition.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ARGUMENT_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        return this.directivesObserve(buildCtx, builder.build());
    }

    void buildOperations(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType query;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        Map<String, OperationTypeDefinition> operationTypeDefs = buildCtx.operationTypeDefs;
        Optional<OperationTypeDefinition> queryOperation = this.getOperationNamed("query", operationTypeDefs);
        if (!queryOperation.isPresent()) {
            TypeDefinition queryTypeDef = typeRegistry.getType("Query").get();
            query = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(queryTypeDef.getName()).build());
        } else {
            query = this.buildOperation(buildCtx, queryOperation.get());
        }
        schemaBuilder.query(query);
        Optional<OperationTypeDefinition> mutationOperation = this.getOperationNamed("mutation", operationTypeDefs);
        if (!mutationOperation.isPresent()) {
            Optional<TypeDefinition> mutationTypeDef = typeRegistry.getType("Mutation");
            if (mutationTypeDef.isPresent()) {
                GraphQLObjectType mutation = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(mutationTypeDef.get().getName()).build());
                schemaBuilder.mutation(mutation);
            }
        } else {
            GraphQLObjectType mutation = this.buildOperation(buildCtx, mutationOperation.get());
            schemaBuilder.mutation(mutation);
        }
        Optional<OperationTypeDefinition> subscriptionOperation = this.getOperationNamed("subscription", operationTypeDefs);
        if (!subscriptionOperation.isPresent()) {
            Optional<TypeDefinition> subscriptionTypeDef = typeRegistry.getType("Subscription");
            if (subscriptionTypeDef.isPresent()) {
                GraphQLObjectType subscription = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(subscriptionTypeDef.get().getName()).build());
                schemaBuilder.subscription(subscription);
            }
        } else {
            GraphQLObjectType subscription = this.buildOperation(buildCtx, subscriptionOperation.get());
            schemaBuilder.subscription(subscription);
        }
    }

    void buildSchemaDirectivesAndExtensions(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        List<Directive> schemaDirectiveList = SchemaExtensionsChecker.gatherSchemaDirectives(typeRegistry);
        Set<GraphQLDirective> runtimeDirectives = buildCtx.getDirectives();
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, this.inputTypeFactory(buildCtx), schemaDirectiveList, Collections.emptyList(), Introspection.DirectiveLocation.SCHEMA, runtimeDirectives, buildCtx.getComparatorRegistry());
        schemaBuilder.withSchemaDirectives((Collection)appliedDirectives.first);
        schemaBuilder.withSchemaAppliedDirectives((Collection)appliedDirectives.second);
        schemaBuilder.definition(buildCtx.isCaptureAstDefinitions() ? (SchemaDefinition)typeRegistry.schemaDefinition().orElse(null) : null);
        schemaBuilder.extensionDefinitions(buildCtx.isCaptureAstDefinitions() ? typeRegistry.getSchemaExtensionDefinitions() : Collections.emptyList());
    }

    List<InputObjectTypeExtensionDefinition> inputObjectTypeExtensions(InputObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().inputObjectTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<EnumTypeExtensionDefinition> enumTypeExtensions(EnumTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().enumTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<ScalarTypeExtensionDefinition> scalarTypeExtensions(ScalarTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().scalarTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<InterfaceTypeExtensionDefinition> interfaceTypeExtensions(InterfaceTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().interfaceTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<ObjectTypeExtensionDefinition> objectTypeExtensions(ObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().objectTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<UnionTypeExtensionDefinition> unionTypeExtensions(UnionTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().unionTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    Set<GraphQLType> buildAdditionalTypes(BuildContext buildCtx) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        Set<String> detachedTypeNames = this.getDetachedTypeNames(buildCtx);
        LinkedHashSet<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
        typeRegistry.types().values().stream().filter(typeDefinition -> detachedTypeNames.contains(typeDefinition.getName())).forEach(typeDefinition -> {
            TypeName typeName = TypeName.newTypeName().name(typeDefinition.getName()).build();
            if (typeDefinition instanceof InputObjectTypeDefinition) {
                if (buildCtx.hasInputType((TypeDefinition<?>)typeDefinition) == null) {
                    buildCtx.putInputType((GraphQLNamedInputType)this.buildInputType(buildCtx, typeName));
                }
                additionalTypes.add((GraphQLType)buildCtx.inputGTypes.get(typeDefinition.getName()));
            } else {
                if (buildCtx.hasOutputType((TypeDefinition<?>)typeDefinition) == null) {
                    buildCtx.putOutputType((GraphQLNamedOutputType)this.buildOutputType(buildCtx, typeName));
                }
                additionalTypes.add((GraphQLType)buildCtx.outputGTypes.get(typeDefinition.getName()));
            }
        });
        typeRegistry.scalars().values().stream().filter(typeDefinition -> detachedTypeNames.contains(typeDefinition.getName())).forEach(scalarTypeDefinition -> {
            if (ScalarInfo.isGraphqlSpecifiedScalar(scalarTypeDefinition.getName())) {
                return;
            }
            if (buildCtx.hasInputType((TypeDefinition<?>)scalarTypeDefinition) == null && buildCtx.hasOutputType((TypeDefinition<?>)scalarTypeDefinition) == null) {
                buildCtx.putOutputType(this.buildScalar(buildCtx, (ScalarTypeDefinition)scalarTypeDefinition));
            }
            if (buildCtx.hasInputType((TypeDefinition<?>)scalarTypeDefinition) != null) {
                additionalTypes.add((GraphQLType)buildCtx.inputGTypes.get(scalarTypeDefinition.getName()));
            } else if (buildCtx.hasOutputType((TypeDefinition<?>)scalarTypeDefinition) != null) {
                additionalTypes.add((GraphQLType)buildCtx.outputGTypes.get(scalarTypeDefinition.getName()));
            }
        });
        return additionalTypes;
    }

    private Set<String> getDetachedTypeNames(BuildContext buildCtx) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        HashSet connectedTypes = new HashSet(buildCtx.inputGTypes.keySet());
        connectedTypes.addAll(buildCtx.outputGTypes.keySet());
        HashSet<String> allTypeNames = new HashSet<String>(typeRegistry.types().keySet());
        HashSet<String> scalars = new HashSet<String>(typeRegistry.scalars().keySet());
        allTypeNames.addAll(scalars);
        HashSet<String> detachedTypeNames = new HashSet<String>(allTypeNames);
        detachedTypeNames.removeAll(connectedTypes);
        return detachedTypeNames;
    }

    Set<GraphQLDirective> buildAdditionalDirectiveDefinitions(BuildContext buildCtx) {
        LinkedHashSet<GraphQLDirective> additionalDirectives = new LinkedHashSet<GraphQLDirective>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        for (DirectiveDefinition directiveDefinition : typeRegistry.getDirectiveDefinitions().values()) {
            GraphQLDirective directive = SchemaGeneratorAppliedDirectiveHelper.buildDirectiveDefinitionFromAst(buildCtx, directiveDefinition, this.inputTypeFactory(buildCtx));
            buildCtx.addDirectiveDefinition(directive);
            additionalDirectives.add(directive);
        }
        return additionalDirectives;
    }

    void addDirectivesIncludedByDefault(TypeDefinitionRegistry typeRegistry) {
        typeRegistry.add(Directives.DEPRECATED_DIRECTIVE_DEFINITION);
        typeRegistry.add(Directives.SPECIFIED_BY_DIRECTIVE_DEFINITION);
    }

    private Optional<OperationTypeDefinition> getOperationNamed(String name, Map<String, OperationTypeDefinition> operationTypeDefs) {
        return Optional.ofNullable(operationTypeDefs.get(name));
    }

    private DataFetcher<?> dataFetcherOfLastResort(FieldWiringEnvironment environment) {
        String fieldName = environment.getFieldDefinition().getName();
        return new PropertyDataFetcher(fieldName);
    }

    private List<Directive> directivesOf(List<? extends TypeDefinition<?>> typeDefinitions) {
        return typeDefinitions.stream().map(DirectivesContainer::getDirectives).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private <T extends GraphQLDirectiveContainer> T directivesObserve(BuildContext buildCtx, T directiveContainer) {
        if (!buildCtx.directiveWiringRequired) {
            boolean requiresWiring = SchemaGeneratorDirectiveHelper.schemaDirectiveWiringIsRequired(directiveContainer, buildCtx.getTypeRegistry(), buildCtx.getWiring());
            buildCtx.directiveWiringRequired |= requiresWiring;
        }
        return directiveContainer;
    }

    static class BuildContext {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring wiring;
        private final Deque<String> typeStack = new ArrayDeque<String>();
        private final Map<String, GraphQLOutputType> outputGTypes = new LinkedHashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLInputType> inputGTypes = new LinkedHashMap<String, GraphQLInputType>();
        private final Set<GraphQLDirective> directives = new LinkedHashSet<GraphQLDirective>();
        private final GraphQLCodeRegistry.Builder codeRegistry;
        public final Map<String, OperationTypeDefinition> operationTypeDefs;
        public final SchemaGenerator.Options options;
        public boolean directiveWiringRequired;

        BuildContext(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring, Map<String, OperationTypeDefinition> operationTypeDefinitions, SchemaGenerator.Options options) {
            this.typeRegistry = typeRegistry;
            this.wiring = wiring;
            this.codeRegistry = GraphQLCodeRegistry.newCodeRegistry(wiring.getCodeRegistry());
            this.operationTypeDefs = operationTypeDefinitions;
            this.options = options;
            this.directiveWiringRequired = false;
        }

        public boolean isDirectiveWiringRequired() {
            return this.directiveWiringRequired;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        TypeDefinition<?> getTypeDefinition(Type<?> type) {
            Optional<TypeDefinition> optionalTypeDefinition = this.typeRegistry.getType(type);
            return optionalTypeDefinition.orElseThrow(() -> new AssertException(String.format(" type definition for type '%s' not found", type)));
        }

        boolean stackContains(TypeInfo typeInfo) {
            return this.typeStack.contains(typeInfo.getName());
        }

        void push(TypeInfo typeInfo) {
            this.typeStack.push(typeInfo.getName());
        }

        void pop() {
            this.typeStack.pop();
        }

        GraphQLOutputType hasOutputType(TypeDefinition<?> typeDefinition) {
            return this.outputGTypes.get(typeDefinition.getName());
        }

        GraphQLInputType hasInputType(TypeDefinition<?> typeDefinition) {
            return this.inputGTypes.get(typeDefinition.getName());
        }

        void putOutputType(GraphQLNamedOutputType outputType) {
            this.outputGTypes.put(outputType.getName(), outputType);
            if (outputType instanceof GraphQLInputType) {
                this.inputGTypes.put(outputType.getName(), (GraphQLInputType)((Object)outputType));
            }
        }

        void putInputType(GraphQLNamedInputType inputType) {
            this.inputGTypes.put(inputType.getName(), inputType);
            if (inputType instanceof GraphQLOutputType) {
                this.outputGTypes.put(inputType.getName(), (GraphQLOutputType)((Object)inputType));
            }
        }

        RuntimeWiring getWiring() {
            return this.wiring;
        }

        GraphqlTypeComparatorRegistry getComparatorRegistry() {
            return this.wiring.getComparatorRegistry();
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }

        public void addDirectiveDefinition(GraphQLDirective directive) {
            this.directives.add(directive);
        }

        public void addDirectives(Set<GraphQLDirective> directives) {
            this.directives.addAll(directives);
        }

        public Set<GraphQLDirective> getDirectives() {
            return this.directives;
        }

        public boolean isCaptureAstDefinitions() {
            return this.options.isCaptureAstDefinitions();
        }
    }
}

