/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLDirective;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.EnumSet;
import java.util.List;

@Internal
public class KnownDirectives
extends AbstractRule {
    public KnownDirectives(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        GraphQLDirective graphQLDirective = this.getValidationContext().getSchema().getDirective(directive.getName());
        if (graphQLDirective == null) {
            String message = String.format("Unknown directive %s", directive.getName());
            this.addError(ValidationErrorType.UnknownDirective, directive.getSourceLocation(), message);
            return;
        }
        Node ancestor = ancestors.get(ancestors.size() - 1);
        if (this.hasInvalidLocation(graphQLDirective, ancestor)) {
            String message = String.format("Directive %s not allowed here", directive.getName());
            this.addError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message);
        }
    }

    private boolean hasInvalidLocation(GraphQLDirective directive, Node ancestor) {
        EnumSet<Introspection.DirectiveLocation> validLocations = directive.validLocations();
        if (ancestor instanceof OperationDefinition) {
            OperationDefinition.Operation operation = ((OperationDefinition)ancestor).getOperation();
            if (OperationDefinition.Operation.QUERY.equals((Object)operation)) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.QUERY);
            }
            if (OperationDefinition.Operation.MUTATION.equals((Object)operation)) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.MUTATION);
            }
            if (OperationDefinition.Operation.SUBSCRIPTION.equals((Object)operation)) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.SUBSCRIPTION);
            }
        } else {
            if (ancestor instanceof Field) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.FIELD);
            }
            if (ancestor instanceof FragmentSpread) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.FRAGMENT_SPREAD);
            }
            if (ancestor instanceof FragmentDefinition) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.FRAGMENT_DEFINITION);
            }
            if (ancestor instanceof InlineFragment) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.INLINE_FRAGMENT);
            }
            if (ancestor instanceof VariableDefinition) {
                return !validLocations.contains((Object)Introspection.DirectiveLocation.VARIABLE_DEFINITION);
            }
        }
        return true;
    }
}

