/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.AstComparator;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.FpKit;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Internal
public class OverlappingFieldsCanBeMerged
extends AbstractRule {
    private final Set<Set<FieldAndType>> sameResponseShapeChecked = new LinkedHashSet<Set<FieldAndType>>();
    private final Set<Set<FieldAndType>> sameForCommonParentsChecked = new LinkedHashSet<Set<FieldAndType>>();
    private final Set<Set<Field>> conflictsReported = new LinkedHashSet<Set<Field>>();

    public OverlappingFieldsCanBeMerged(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void leaveSelectionSet(SelectionSet selectionSet) {
        LinkedHashMap<String, Set<FieldAndType>> fieldMap = new LinkedHashMap<String, Set<FieldAndType>>();
        LinkedHashSet<String> visitedFragmentSpreads = new LinkedHashSet<String>();
        this.collectFields(fieldMap, selectionSet, this.getValidationContext().getOutputType(), visitedFragmentSpreads);
        List<Conflict> conflicts = this.findConflicts(fieldMap);
        for (Conflict conflict : conflicts) {
            if (this.conflictsReported.contains(conflict.fields)) continue;
            this.conflictsReported.add(conflict.fields);
            this.addError(ValidationErrorType.FieldsConflict, conflict.fields, conflict.reason);
        }
    }

    private void collectFields(Map<String, Set<FieldAndType>> fieldMap, SelectionSet selectionSet, GraphQLType parentType, Set<String> visitedFragmentSpreads) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectFieldsForField(fieldMap, parentType, (Field)selection);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectFieldsForInlineFragment(fieldMap, visitedFragmentSpreads, parentType, (InlineFragment)selection);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFieldsForFragmentSpread(fieldMap, visitedFragmentSpreads, (FragmentSpread)selection);
        }
    }

    private void collectFieldsForFragmentSpread(Map<String, Set<FieldAndType>> fieldMap, Set<String> visitedFragmentSpreads, FragmentSpread fragmentSpread) {
        FragmentDefinition fragment = this.getValidationContext().getFragment(fragmentSpread.getName());
        if (fragment == null) {
            return;
        }
        if (visitedFragmentSpreads.contains(fragment.getName())) {
            return;
        }
        visitedFragmentSpreads.add(fragment.getName());
        GraphQLType graphQLType = this.getGraphQLTypeForFragmentDefinition(fragment);
        this.collectFields(fieldMap, fragment.getSelectionSet(), graphQLType, visitedFragmentSpreads);
    }

    private GraphQLType getGraphQLTypeForFragmentDefinition(FragmentDefinition fragment) {
        return TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), fragment.getTypeCondition());
    }

    private void collectFieldsForInlineFragment(Map<String, Set<FieldAndType>> fieldMap, Set<String> visitedFragmentSpreads, GraphQLType parentType, InlineFragment inlineFragment) {
        GraphQLType graphQLType = this.getGraphQLTypeForInlineFragment(parentType, inlineFragment);
        this.collectFields(fieldMap, inlineFragment.getSelectionSet(), graphQLType, visitedFragmentSpreads);
    }

    private GraphQLType getGraphQLTypeForInlineFragment(GraphQLType parentType, InlineFragment inlineFragment) {
        if (inlineFragment.getTypeCondition() == null) {
            return parentType;
        }
        return TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), inlineFragment.getTypeCondition());
    }

    private void collectFieldsForField(Map<String, Set<FieldAndType>> fieldMap, GraphQLType parentType, Field field) {
        String responseName = field.getResultKey();
        if (!fieldMap.containsKey(responseName)) {
            fieldMap.put(responseName, new LinkedHashSet());
        }
        GraphQLOutputType fieldType = null;
        GraphQLUnmodifiedType unwrappedParent = GraphQLTypeUtil.unwrapAll(parentType);
        if (unwrappedParent instanceof GraphQLFieldsContainer) {
            GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)((Object)unwrappedParent);
            GraphQLFieldDefinition fieldDefinition = this.getVisibleFieldDefinition(fieldsContainer, field);
            fieldType = fieldDefinition != null ? fieldDefinition.getType() : null;
        }
        fieldMap.get(responseName).add(new FieldAndType(field, fieldType, parentType));
    }

    private GraphQLFieldDefinition getVisibleFieldDefinition(GraphQLFieldsContainer fieldsContainer, Field field) {
        return this.getValidationContext().getSchema().getCodeRegistry().getFieldVisibility().getFieldDefinition(fieldsContainer, field.getName());
    }

    private List<Conflict> findConflicts(Map<String, Set<FieldAndType>> fieldMap) {
        ArrayList<Conflict> result = new ArrayList<Conflict>();
        this.sameResponseShapeByName(fieldMap, ImmutableKit.emptyList(), result);
        this.sameForCommonParentsByName(fieldMap, ImmutableKit.emptyList(), result);
        return result;
    }

    private void sameResponseShapeByName(Map<String, Set<FieldAndType>> fieldMap, ImmutableList<String> currentPath, List<Conflict> conflictsResult) {
        for (Map.Entry<String, Set<FieldAndType>> entry : fieldMap.entrySet()) {
            if (this.sameResponseShapeChecked.contains(entry.getValue())) continue;
            ImmutableList<String> newPath = ImmutableKit.addToList(currentPath, entry.getKey(), new String[0]);
            this.sameResponseShapeChecked.add(entry.getValue());
            Conflict conflict = this.requireSameOutputTypeShape(newPath, entry.getValue());
            if (conflict != null) {
                conflictsResult.add(conflict);
                continue;
            }
            Map<String, Set<FieldAndType>> subSelections = this.mergeSubSelections(entry.getValue());
            this.sameResponseShapeByName(subSelections, newPath, conflictsResult);
        }
    }

    private Map<String, Set<FieldAndType>> mergeSubSelections(Set<FieldAndType> sameNameFields) {
        LinkedHashMap<String, Set<FieldAndType>> fieldMap = new LinkedHashMap<String, Set<FieldAndType>>();
        for (FieldAndType fieldAndType : sameNameFields) {
            if (fieldAndType.field.getSelectionSet() == null) continue;
            LinkedHashSet<String> visitedFragmentSpreads = new LinkedHashSet<String>();
            this.collectFields(fieldMap, fieldAndType.field.getSelectionSet(), fieldAndType.graphQLType, visitedFragmentSpreads);
        }
        return fieldMap;
    }

    private void sameForCommonParentsByName(Map<String, Set<FieldAndType>> fieldMap, ImmutableList<String> currentPath, List<Conflict> conflictsResult) {
        for (Map.Entry<String, Set<FieldAndType>> entry : fieldMap.entrySet()) {
            List<Set<FieldAndType>> groups = this.groupByCommonParents(entry.getValue());
            ImmutableList<String> newPath = ImmutableKit.addToList(currentPath, entry.getKey(), new String[0]);
            for (Set<FieldAndType> group : groups) {
                if (this.sameForCommonParentsChecked.contains(group)) continue;
                this.sameForCommonParentsChecked.add(group);
                Conflict conflict = this.requireSameNameAndArguments(newPath, group);
                if (conflict != null) {
                    conflictsResult.add(conflict);
                    continue;
                }
                Map<String, Set<FieldAndType>> subSelections = this.mergeSubSelections(group);
                this.sameForCommonParentsByName(subSelections, newPath, conflictsResult);
            }
        }
    }

    private List<Set<FieldAndType>> groupByCommonParents(Set<FieldAndType> fields) {
        Set<FieldAndType> abstractTypes = FpKit.filterSet(fields, fieldAndType -> this.isInterfaceOrUnion(fieldAndType.parentType));
        Set<FieldAndType> concreteTypes = FpKit.filterSet(fields, fieldAndType -> fieldAndType.parentType instanceof GraphQLObjectType);
        if (concreteTypes.isEmpty()) {
            return Collections.singletonList(abstractTypes);
        }
        Map<GraphQLType, ImmutableList<FieldAndType>> groupsByConcreteParent = FpKit.groupingBy(concreteTypes, fieldAndType -> fieldAndType.parentType);
        ArrayList<Set<FieldAndType>> result = new ArrayList<Set<FieldAndType>>();
        for (ImmutableList<FieldAndType> concreteGroup : groupsByConcreteParent.values()) {
            LinkedHashSet<FieldAndType> oneResultGroup = new LinkedHashSet<FieldAndType>(concreteGroup);
            oneResultGroup.addAll(abstractTypes);
            result.add(oneResultGroup);
        }
        return result;
    }

    private boolean isInterfaceOrUnion(GraphQLType type) {
        return type instanceof GraphQLInterfaceType || type instanceof GraphQLUnionType;
    }

    private Conflict requireSameNameAndArguments(ImmutableList<String> path, Set<FieldAndType> fieldAndTypes) {
        if (fieldAndTypes.size() <= 1) {
            return null;
        }
        String name = null;
        List<Argument> arguments = null;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldAndType fieldAndType : fieldAndTypes) {
            Field field = fieldAndType.field;
            fields.add(field);
            if (name == null) {
                name = field.getName();
                arguments = field.getArguments();
                continue;
            }
            if (!field.getName().equals(name)) {
                String reason = String.format("%s: %s and %s are different fields", this.pathToString(path), name, field.getName());
                return new Conflict(reason, fields);
            }
            if (this.sameArguments(field.getArguments(), arguments)) continue;
            String reason = String.format("%s: they have differing arguments", this.pathToString(path));
            return new Conflict(reason, fields);
        }
        return null;
    }

    private String pathToString(ImmutableList<String> path) {
        return String.join((CharSequence)"/", path);
    }

    private boolean sameArguments(List<Argument> arguments1, List<Argument> arguments2) {
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (Argument argument : arguments1) {
            Argument matchedArgument = this.findArgumentByName(argument.getName(), arguments2);
            if (matchedArgument == null) {
                return false;
            }
            if (AstComparator.sameValue(argument.getValue(), matchedArgument.getValue())) continue;
            return false;
        }
        return true;
    }

    private Argument findArgumentByName(String name, List<Argument> arguments) {
        for (Argument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    private Conflict requireSameOutputTypeShape(ImmutableList<String> path, Set<FieldAndType> fieldAndTypes) {
        if (fieldAndTypes.size() <= 1) {
            return null;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        GraphQLType typeAOriginal = null;
        for (FieldAndType fieldAndType : fieldAndTypes) {
            fields.add(fieldAndType.field);
            if (typeAOriginal == null) {
                typeAOriginal = fieldAndType.graphQLType;
                continue;
            }
            GraphQLType typeA = typeAOriginal;
            GraphQLType typeB = fieldAndType.graphQLType;
            while (true) {
                if ((GraphQLTypeUtil.isNonNull(typeA) || GraphQLTypeUtil.isNonNull(typeB)) && (GraphQLTypeUtil.isNullable(typeA) || GraphQLTypeUtil.isNullable(typeB))) {
                    String reason = String.format("%s: fields have different nullability shapes", this.pathToString(path));
                    return new Conflict(reason, fields);
                }
                if (!(!GraphQLTypeUtil.isList(typeA) && !GraphQLTypeUtil.isList(typeB) || GraphQLTypeUtil.isList(typeA) && GraphQLTypeUtil.isList(typeB))) {
                    String reason = String.format("%s: fields have different list shapes", this.pathToString(path));
                    return new Conflict(reason, fields);
                }
                if (GraphQLTypeUtil.isNotWrapped(typeA) && GraphQLTypeUtil.isNotWrapped(typeB)) break;
                typeA = GraphQLTypeUtil.unwrapOne(typeA);
                typeB = GraphQLTypeUtil.unwrapOne(typeB);
            }
            if ((GraphQLTypeUtil.isScalar(typeA) || GraphQLTypeUtil.isScalar(typeB)) && !this.sameType(typeA, typeB)) {
                return this.mkNotSameTypeError(path, fields, typeA, typeB);
            }
            if (!GraphQLTypeUtil.isEnum(typeA) && !GraphQLTypeUtil.isEnum(typeB) || this.sameType(typeA, typeB)) continue;
            return this.mkNotSameTypeError(path, fields, typeA, typeB);
        }
        return null;
    }

    private Conflict mkNotSameTypeError(ImmutableList<String> path, List<Field> fields, GraphQLType typeA, GraphQLType typeB) {
        String name1 = typeA != null ? GraphQLTypeUtil.simplePrint(typeA) : "null";
        String name2 = typeB != null ? GraphQLTypeUtil.simplePrint(typeB) : "null";
        String reason = String.format("%s: they return differing types %s and %s", this.pathToString(path), name1, name2);
        return new Conflict(reason, fields);
    }

    private boolean sameType(GraphQLType type1, GraphQLType type2) {
        if (type1 == null || type2 == null) {
            return true;
        }
        return type1.equals(type2);
    }

    private static class Conflict {
        final String reason;
        final Set<Field> fields = new LinkedHashSet<Field>();

        public Conflict(String reason, List<Field> fields) {
            this.reason = reason;
            this.fields.addAll(fields);
        }
    }

    private static class FieldAndType {
        final Field field;
        final GraphQLType graphQLType;
        final GraphQLType parentType;

        public FieldAndType(Field field, GraphQLType graphQLType, GraphQLType parentType) {
            this.field = field;
            this.graphQLType = graphQLType;
            this.parentType = parentType;
        }

        public String toString() {
            return "FieldAndType{field=" + this.field + ", graphQLType=" + this.graphQLType + ", parentType=" + this.parentType + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldAndType that = (FieldAndType)o;
            return Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hashCode(this.field);
        }
    }
}

