/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLDirective;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.List;

@Internal
public class UniqueDirectiveNamesPerLocation
extends AbstractRule {
    public UniqueDirectiveNamesPerLocation(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDocument(Document document) {
        super.checkDocument(document);
    }

    @Override
    public void checkInlineFragment(InlineFragment inlineFragment) {
        this.checkDirectivesUniqueness(inlineFragment, inlineFragment.getDirectives());
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        this.checkDirectivesUniqueness(fragmentDefinition, fragmentDefinition.getDirectives());
    }

    @Override
    public void checkFragmentSpread(FragmentSpread fragmentSpread) {
        this.checkDirectivesUniqueness(fragmentSpread, fragmentSpread.getDirectives());
    }

    @Override
    public void checkField(Field field) {
        this.checkDirectivesUniqueness(field, field.getDirectives());
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        this.checkDirectivesUniqueness(operationDefinition, operationDefinition.getDirectives());
    }

    private void checkDirectivesUniqueness(Node<?> directivesContainer, List<Directive> directives) {
        LinkedHashSet<String> directiveNames = new LinkedHashSet<String>();
        for (Directive directive : directives) {
            boolean nonRepeatable;
            String name = directive.getName();
            GraphQLDirective graphQLDirective = this.getValidationContext().getSchema().getDirective(name);
            boolean bl = nonRepeatable = graphQLDirective != null && graphQLDirective.isNonRepeatable();
            if (directiveNames.contains(name) && nonRepeatable) {
                this.addError(ValidationErrorType.DuplicateDirectiveName, directive.getSourceLocation(), this.duplicateDirectiveNameMessage(name, directivesContainer.getClass().getSimpleName()));
                continue;
            }
            directiveNames.add(name);
        }
    }

    private String duplicateDirectiveNameMessage(String directiveName, String location) {
        return String.format("Non repeatable directives must be uniquely named within a location. The directive '%s' used on a '%s' is not unique.", directiveName, location);
    }
}

