/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class VariablesAreInputTypes
extends AbstractRule {
    public VariablesAreInputTypes(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkVariableDefinition(VariableDefinition variableDefinition) {
        TypeName unmodifiedAstType = this.getValidationUtil().getUnmodifiedType(variableDefinition.getType());
        GraphQLType type = this.getValidationContext().getSchema().getType(unmodifiedAstType.getName());
        if (type == null) {
            return;
        }
        if (!GraphQLTypeUtil.isInput(type)) {
            String message = "Wrong type for a variable";
            this.addError(ValidationErrorType.NonInputTypeOnVariable, variableDefinition.getSourceLocation(), message);
        }
    }
}

