/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Watch;
import io.vertx.ext.consul.WatchResult;
import java.util.concurrent.TimeoutException;

public abstract class WatchImpl<T>
implements Watch<T> {
    private static final String BLOCKING_WAIT = "10m";
    private static final int DELAY_LIMIT_SECONDS = 180;
    private volatile boolean started = false;
    private volatile boolean stopped = false;
    private Handler<WatchResult<T>> handler;
    private State<T> current = new State<Object>(null, 0L);
    protected final Vertx vertx;
    protected final ConsulClient consulClient;

    private WatchImpl(Vertx vertx, ConsulClient consulClient) {
        this.vertx = vertx;
        this.consulClient = consulClient;
    }

    abstract void wait(long var1, Handler<AsyncResult<State<T>>> var3);

    @Override
    public Watch<T> setHandler(Handler<WatchResult<T>> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public synchronized Watch<T> start() {
        if (this.started) {
            throw new IllegalStateException("Watch already started");
        }
        this.started = true;
        this.vertx.runOnContext(v -> this.go());
        return this;
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("An unstarted watch");
        }
        if (this.stopped) {
            throw new IllegalStateException("Watch already stopped");
        }
        this.stopped = true;
        this.consulClient.close();
    }

    private void go() {
        this.fetch(0L, newState -> {
            if (newState.equals(this.current)) {
                this.vertx.setTimer(1000L, l -> this.go());
            } else {
                State<T> prevState = this.current;
                this.current = newState;
                this.sendSuccess(prevState.value, newState.value);
                this.vertx.runOnContext(v -> this.go());
            }
        });
    }

    private void fetch(long cnt, Handler<State<T>> result) {
        if (this.stopped) {
            return;
        }
        this.wait(this.current.index, h -> {
            if (this.stopped) {
                return;
            }
            if (h.succeeded()) {
                result.handle(h.result());
            } else {
                Throwable cause = h.cause();
                if (cause instanceof TimeoutException) {
                    this.vertx.runOnContext(v -> this.fetch(0L, result));
                } else {
                    this.sendFail(this.current.value, h.cause());
                    long newCnt = cnt + 1L;
                    long delay = newCnt * newCnt;
                    if (delay > 180L) {
                        delay = 180L;
                    }
                    this.vertx.setTimer(delay * 1000L, l -> this.fetch(newCnt, result));
                }
            }
        });
    }

    private void sendSuccess(final T prevValue, final T nextValue) {
        if (!this.stopped && this.handler != null) {
            this.handler.handle((Object)new WatchResult<T>(){

                @Override
                public T prevResult() {
                    return prevValue;
                }

                @Override
                public T nextResult() {
                    return nextValue;
                }

                @Override
                public Throwable cause() {
                    return null;
                }

                @Override
                public boolean succeeded() {
                    return true;
                }

                @Override
                public boolean failed() {
                    return false;
                }
            });
        }
    }

    private void sendFail(final T prevValue, final Throwable cause) {
        if (!this.stopped && this.handler != null) {
            this.handler.handle((Object)new WatchResult<T>(){

                @Override
                public T prevResult() {
                    return prevValue;
                }

                @Override
                public T nextResult() {
                    return null;
                }

                @Override
                public Throwable cause() {
                    return cause;
                }

                @Override
                public boolean succeeded() {
                    return false;
                }

                @Override
                public boolean failed() {
                    return true;
                }
            });
        }
    }

    static class State<T> {
        final T value;
        final long index;

        State(T v, long i) {
            this.value = v;
            this.index = i;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.index == state.index && (this.value != null ? this.value.equals(state.value) : state.value == null);
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (int)(this.index ^ this.index >>> 32);
            return result;
        }
    }

    public static class Nodes
    extends WatchImpl<NodeList> {
        public Nodes(Vertx vertx, ConsulClientOptions options) {
            super(vertx, ConsulClient.create(vertx, options));
        }

        @Override
        void wait(long index, Handler<AsyncResult<State<NodeList>>> handler) {
            BlockingQueryOptions bOpts = new BlockingQueryOptions().setWait(WatchImpl.BLOCKING_WAIT).setIndex(index);
            NodeQueryOptions qOpts = new NodeQueryOptions().setBlockingOptions(bOpts);
            this.consulClient.catalogNodesWithOptions(qOpts, (Handler<AsyncResult<NodeList>>)((Handler)h -> handler.handle((Object)h.map(nodes -> new State<NodeList>((NodeList)nodes, nodes.getIndex())))));
        }
    }

    public static class Events
    extends WatchImpl<EventList> {
        private final String event;

        public Events(String event, Vertx vertx, ConsulClientOptions options) {
            super(vertx, ConsulClient.create(vertx, options));
            this.event = event;
        }

        @Override
        void wait(long index, Handler<AsyncResult<State<EventList>>> handler) {
            BlockingQueryOptions bOpts = new BlockingQueryOptions().setWait(WatchImpl.BLOCKING_WAIT).setIndex(index);
            EventListOptions eOpts = new EventListOptions().setBlockingOptions(bOpts).setName(this.event);
            this.consulClient.listEventsWithOptions(eOpts, (Handler<AsyncResult<EventList>>)((Handler)h -> handler.handle((Object)h.map(events -> new State<EventList>((EventList)events, events.getIndex())))));
        }
    }

    public static class Service
    extends WatchImpl<ServiceEntryList> {
        private final String service;

        public Service(String service, Vertx vertx, ConsulClientOptions options) {
            super(vertx, ConsulClient.create(vertx, options));
            this.service = service;
        }

        @Override
        void wait(long index, Handler<AsyncResult<State<ServiceEntryList>>> handler) {
            BlockingQueryOptions bOpts = new BlockingQueryOptions().setWait(WatchImpl.BLOCKING_WAIT).setIndex(index);
            ServiceQueryOptions sOpts = new ServiceQueryOptions().setNear("_agent").setBlockingOptions(bOpts);
            this.consulClient.healthServiceNodesWithOptions(this.service, false, sOpts, (Handler<AsyncResult<ServiceEntryList>>)((Handler)h -> handler.handle((Object)h.map(services -> new State<ServiceEntryList>((ServiceEntryList)services, services.getIndex())))));
        }
    }

    public static class Services
    extends WatchImpl<ServiceList> {
        public Services(Vertx vertx, ConsulClientOptions options) {
            super(vertx, ConsulClient.create(vertx, options));
        }

        @Override
        void wait(long index, Handler<AsyncResult<State<ServiceList>>> handler) {
            BlockingQueryOptions options = new BlockingQueryOptions().setWait(WatchImpl.BLOCKING_WAIT).setIndex(index);
            this.consulClient.catalogServicesWithOptions(options, (Handler<AsyncResult<ServiceList>>)((Handler)h -> handler.handle((Object)h.map(services -> new State<ServiceList>((ServiceList)services, services.getIndex())))));
        }
    }

    public static class KeyPrefix
    extends WatchImpl<KeyValueList> {
        private final String keyPrefix;

        public KeyPrefix(String keyPrefix, Vertx vertx, ConsulClientOptions options) {
            super(vertx, ConsulClient.create(vertx, options));
            this.keyPrefix = keyPrefix;
        }

        @Override
        void wait(long index, Handler<AsyncResult<State<KeyValueList>>> handler) {
            BlockingQueryOptions options = new BlockingQueryOptions().setWait(WatchImpl.BLOCKING_WAIT).setIndex(index);
            this.consulClient.getValuesWithOptions(this.keyPrefix, options, (Handler<AsyncResult<KeyValueList>>)((Handler)h -> handler.handle((Object)h.map(kv -> new State<KeyValueList>((KeyValueList)kv, kv.getIndex())))));
        }
    }

    public static class Key
    extends WatchImpl<KeyValue> {
        private final String key;

        public Key(String key, Vertx vertx, ConsulClientOptions options) {
            super(vertx, ConsulClient.create(vertx, options));
            this.key = key;
        }

        @Override
        void wait(long index, Handler<AsyncResult<State<KeyValue>>> handler) {
            BlockingQueryOptions options = new BlockingQueryOptions().setWait(WatchImpl.BLOCKING_WAIT).setIndex(index);
            this.consulClient.getValueWithOptions(this.key, options, (Handler<AsyncResult<KeyValue>>)((Handler)h -> handler.handle((Object)h.map(kv -> new State<KeyValue>((KeyValue)kv, kv.getModifyIndex())))));
        }
    }
}

