/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.zookeeper;

import io.vertx.servicediscovery.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.curator.x.discovery.ServiceInstance;

class RegistrationHolder<T> {
    private final T svc;
    private final Record record;

    RegistrationHolder(Record record, T svc) {
        this.record = record;
        this.svc = svc;
    }

    private T svc() {
        return this.svc;
    }

    Record record() {
        return this.record;
    }

    static <T> Set<RegistrationHolder<ServiceInstance<T>>> filter(Set<RegistrationHolder<ServiceInstance<T>>> registrations, Collection<ServiceInstance<T>> instances) {
        ArrayList<RegistrationHolder<ServiceInstance<T>>> toRemove = new ArrayList<RegistrationHolder<ServiceInstance<T>>>();
        for (RegistrationHolder<ServiceInstance<T>> holder : registrations) {
            for (ServiceInstance<T> instance : instances) {
                String id = instance.getId();
                if (!super.svc().getId().equals(id)) continue;
                toRemove.add(holder);
            }
        }
        registrations.removeAll(toRemove);
        return registrations;
    }

    static <T> Set<ServiceInstance<T>> filter(Set<ServiceInstance<T>> instances, Set<RegistrationHolder<ServiceInstance<T>>> registrations) {
        ArrayList<ServiceInstance<T>> toRemove = new ArrayList<ServiceInstance<T>>();
        for (ServiceInstance<T> instance : instances) {
            String id = instance.getId();
            for (RegistrationHolder<ServiceInstance<T>> holder : registrations) {
                if (!super.svc().getId().equals(id)) continue;
                toRemove.add(instance);
            }
        }
        instances.removeAll(toRemove);
        return instances;
    }
}

