/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.ColumnData;
import io.vertx.mssqlclient.impl.codec.CursorData;
import io.vertx.mssqlclient.impl.codec.DataType;
import io.vertx.mssqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.RowResultDecoder;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;

class ExtendedCursorQueryCommandCodec<T>
extends ExtendedQueryCommandBaseCodec<T> {
    private final CursorData cursorData;

    ExtendedCursorQueryCommandCodec(TdsMessageCodec tdsMessageCodec, ExtendedQueryCommand<T> cmd) {
        super(tdsMessageCodec, cmd);
        this.cursorData = tdsMessageCodec.getOrCreateCursorData(cmd.cursorId());
    }

    @Override
    void encode() {
        if (this.cursorData.preparedHandle == 0) {
            this.sendCursorPrepExec();
        } else {
            this.rowResultDecoder = new RowResultDecoder(((ExtendedQueryCommand)this.cmd).collector(), this.cursorData.mssqlRowDesc);
            this.sendCursorFetch();
        }
    }

    private void sendCursorPrepExec() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        content.writeShortLE(65535);
        content.writeShortLE(5);
        content.writeShortLE(0);
        DataType.INTN.encodeParam(content, null, true, 0);
        DataType.INTN.encodeParam(content, null, true, 0);
        TupleInternal params = this.prepexecRequestParams();
        String paramDefinitions = this.parseParamDefinitions(params);
        DataType.NVARCHAR.encodeParam(content, null, false, paramDefinitions);
        DataType.NVARCHAR.encodeParam(content, null, false, ((ExtendedQueryCommand)this.cmd).sql());
        int scrollOpt = params.size() == 0 ? 8 : 4104;
        DataType.INTN.encodeParam(content, null, false, scrollOpt);
        int ccOpt = 8193;
        DataType.INTN.encodeParam(content, null, false, ccOpt);
        DataType.INTN.encodeParam(content, null, true, 0);
        this.encodeParams(content, params);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
    }

    @Override
    protected void handleResultSetDone() {
        if (this.cursorData.fetchSent) {
            super.handleResultSetDone();
        }
    }

    @Override
    protected void handleDecodingComplete() {
        if (!this.cursorData.fetchSent) {
            this.sendCursorFetch();
        } else {
            this.result = this.cursorData.hasMore();
            this.complete();
        }
    }

    @Override
    protected MSSQLRowDesc createRowDesc(ColumnData[] columnData) {
        this.cursorData.mssqlRowDesc = MSSQLRowDesc.create(columnData, true);
        return this.cursorData.mssqlRowDesc;
    }

    private void sendCursorFetch() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        content.writeShortLE(65535);
        content.writeShortLE(7);
        content.writeByte(2);
        content.writeByte(0);
        DataType.INTN.encodeParam(content, null, false, this.cursorData.serverCursorId);
        DataType.INTN.encodeParam(content, null, false, 2);
        DataType.INTN.encodeParam(content, null, false, 0);
        DataType.INTN.encodeParam(content, null, false, ((ExtendedQueryCommand)this.cmd).fetch());
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
        if (!this.cursorData.fetchSent) {
            this.cursorData.fetchSent = true;
        }
    }

    @Override
    protected void handleReturnValue(ByteBuf payload) {
        short paramNameLength = payload.getUnsignedByte(payload.readerIndex() + 2);
        payload.skipBytes(12 + 2 * paramNameLength);
        Number value = (Number)DataType.INTN.decodeValue(payload, null);
        if (this.cursorData.preparedHandle == 0) {
            this.cursorData.preparedHandle = value.intValue();
        } else if (this.cursorData.serverCursorId == 0) {
            this.cursorData.serverCursorId = value.intValue();
        } else {
            this.cursorData.rowsTotal = value.intValue();
        }
    }

    @Override
    protected void handleRow(ByteBuf payload) {
        ++this.cursorData.rowsFetched;
        super.handleRow(payload);
    }

    @Override
    protected void handleNbcRow(ByteBuf payload) {
        ++this.cursorData.rowsFetched;
        super.handleNbcRow(payload);
    }

    @Override
    protected TupleInternal prepexecRequestParams() {
        return (TupleInternal)((ExtendedQueryCommand)this.cmd).params();
    }

    @Override
    protected TupleInternal execRequestParams() {
        throw new UnsupportedOperationException();
    }
}

