/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.vertx.mssqlclient.impl.codec.ColumnData;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.impl.RowDesc;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class MSSQLRowDesc
extends RowDesc {
    private final ColumnData[] columnDatas;
    private final boolean rowStat;

    private MSSQLRowDesc(List<String> columnNames, List<ColumnDescriptor> columnDescriptors, ColumnData[] columnDatas, boolean hasRowStat) {
        super(columnNames, columnDescriptors);
        this.columnDatas = columnDatas;
        this.rowStat = hasRowStat;
    }

    public static MSSQLRowDesc create(final ColumnData[] columnDatas, boolean hasRowStat) {
        if (columnDatas.length == 0) {
            return new MSSQLRowDesc(Collections.emptyList(), Collections.emptyList(), columnDatas, false);
        }
        final int size = hasRowStat ? columnDatas.length - 1 : columnDatas.length;
        AbstractList<String> columnNames = new AbstractList<String>(){

            @Override
            public String get(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException();
                }
                return columnDatas[index].name();
            }

            @Override
            public int size() {
                return size;
            }
        };
        AbstractList<ColumnDescriptor> columnDescriptors = new AbstractList<ColumnDescriptor>(){

            @Override
            public ColumnDescriptor get(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException();
                }
                return columnDatas[index];
            }

            @Override
            public int size() {
                return size;
            }
        };
        return new MSSQLRowDesc((List<String>)columnNames, (List<ColumnDescriptor>)columnDescriptors, columnDatas, hasRowStat);
    }

    public int size() {
        return this.rowStat ? this.columnDatas.length - 1 : this.columnDatas.length;
    }

    public ColumnData get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.columnDatas[index];
    }

    public boolean hasRowStat() {
        return this.rowStat;
    }
}

