/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.vertx.mssqlclient.impl.codec.CloseConnectionCommandCodec;
import io.vertx.mssqlclient.impl.codec.CloseCursorCommandCodec;
import io.vertx.mssqlclient.impl.codec.CloseStatementCommandCodec;
import io.vertx.mssqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.InitCommandCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.PreLoginCommandCodec;
import io.vertx.mssqlclient.impl.codec.PrepareStatementCodec;
import io.vertx.mssqlclient.impl.codec.SQLBatchCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;

public class TdsMessageEncoder
extends ChannelOutboundHandlerAdapter {
    private final TdsMessageCodec tdsMessageCodec;
    private ChannelHandlerContext chctx;
    private ByteBufAllocator alloc;
    private int payloadMaxLength;

    public TdsMessageEncoder(TdsMessageCodec tdsMessageCodec, int packetSize) {
        this.tdsMessageCodec = tdsMessageCodec;
        this.setPacketSize(packetSize);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
        this.alloc = this.chctx.alloc();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CommandBase) {
            CommandBase cmd = (CommandBase)msg;
            this.write(cmd);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    void write(CommandBase<?> cmd) {
        MSSQLCommandCodec<?, ?> codec = this.wrap(cmd);
        codec.completionHandler = resp -> {
            MSSQLCommandCodec<?, ?> c = this.tdsMessageCodec.poll();
            resp.cmd = c.cmd;
            this.chctx.fireChannelRead(resp);
        };
        this.tdsMessageCodec.add(codec);
        codec.encode();
    }

    private MSSQLCommandCodec<?, ?> wrap(CommandBase<?> cmd) {
        if (cmd instanceof PreLoginCommand) {
            return new PreLoginCommandCodec(this.tdsMessageCodec, (PreLoginCommand)cmd);
        }
        if (cmd instanceof InitCommand) {
            return new InitCommandCodec(this.tdsMessageCodec, (InitCommand)cmd);
        }
        if (cmd instanceof SimpleQueryCommand) {
            return new SQLBatchCommandCodec(this.tdsMessageCodec, (SimpleQueryCommand)cmd);
        }
        if (cmd instanceof PrepareStatementCommand) {
            return new PrepareStatementCodec(this.tdsMessageCodec, (PrepareStatementCommand)cmd);
        }
        if (cmd instanceof ExtendedQueryCommand) {
            return ExtendedQueryCommandBaseCodec.create(this.tdsMessageCodec, (ExtendedQueryCommand)cmd);
        }
        if (cmd instanceof CloseStatementCommand) {
            return new CloseStatementCommandCodec(this.tdsMessageCodec, (CloseStatementCommand)cmd);
        }
        if (cmd == CloseConnectionCommand.INSTANCE) {
            return new CloseConnectionCommandCodec(this.tdsMessageCodec, (CloseConnectionCommand)cmd);
        }
        if (cmd instanceof CloseCursorCommand) {
            return new CloseCursorCommandCodec(this.tdsMessageCodec, (CloseCursorCommand)cmd);
        }
        throw new UnsupportedOperationException();
    }

    public int packetSize() {
        return this.payloadMaxLength + 8;
    }

    void setPacketSize(int packetSize) {
        int packetMaxLength = Math.max(512, packetSize);
        this.payloadMaxLength = packetMaxLength - 8;
    }

    void encodeHeaders(ByteBuf content) {
        int startIdx = content.writerIndex();
        content.writeIntLE(0);
        this.encodeTransactionDescriptor(content);
        content.setIntLE(startIdx, content.writerIndex() - startIdx);
    }

    private void encodeTransactionDescriptor(ByteBuf content) {
        content.writeIntLE(18);
        content.writeShortLE(2);
        content.writeLongLE(this.tdsMessageCodec.transactionDescriptor());
        content.writeIntLE(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTdsMessage(short messageType, ByteBuf tdsMessageContent) {
        try {
            int tdsMessageLength = tdsMessageContent.writerIndex();
            int numPackets = tdsMessageLength / this.payloadMaxLength + (tdsMessageLength % this.payloadMaxLength == 0 ? 0 : 1);
            for (int i = 0; i < numPackets; ++i) {
                int start = i * this.payloadMaxLength;
                int length = Math.min(tdsMessageLength - start, this.payloadMaxLength);
                ByteBuf slice = tdsMessageContent.retainedSlice(start, length);
                short status = 0;
                if (i == numPackets - 1) {
                    status = (short)(status | 1);
                }
                this.writeTdsPacket(messageType, status, length, slice);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)tdsMessageContent);
        }
    }

    private void writeTdsPacket(short messageType, short status, int length, ByteBuf payload) {
        ByteBuf header = this.alloc.ioBuffer(8);
        header.writeByte((int)messageType);
        header.writeByte((int)status);
        header.writeShort(8 + length);
        header.writeZero(4);
        this.chctx.write((Object)header, this.chctx.voidPromise());
        this.chctx.writeAndFlush((Object)payload, this.chctx.voidPromise());
    }
}

