/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.util;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public class BufferUtils {
    private static final byte TERMINAL = 0;

    public static String readNullTerminatedString(ByteBuf buffer, Charset charset) {
        int len = buffer.bytesBefore((byte)0);
        String s = buffer.readCharSequence(len, charset).toString();
        buffer.readByte();
        return s;
    }

    public static String readFixedLengthString(ByteBuf buffer, int length, Charset charset) {
        return buffer.readCharSequence(length, charset).toString();
    }

    public static void writeNullTerminatedString(ByteBuf buffer, CharSequence charSequence, Charset charset) {
        buffer.writeCharSequence(charSequence, charset);
        buffer.writeByte(0);
    }

    public static void writeLengthEncodedInteger(ByteBuf buffer, long value) {
        if (value < 251L) {
            buffer.writeByte((int)((byte)value));
        } else if (value <= 65535L) {
            buffer.writeByte(252);
            buffer.writeShortLE((int)value);
        } else if (value < 0xFFFFFFL) {
            buffer.writeByte(253);
            buffer.writeMediumLE((int)value);
        } else {
            buffer.writeByte(254);
            buffer.writeLongLE(value);
        }
    }

    public static long readLengthEncodedInteger(ByteBuf buffer) {
        short firstByte = buffer.readUnsignedByte();
        switch (firstByte) {
            case 251: {
                return -1L;
            }
            case 252: {
                return buffer.readUnsignedShortLE();
            }
            case 253: {
                return buffer.readUnsignedMediumLE();
            }
            case 254: {
                return buffer.readLongLE();
            }
        }
        return firstByte;
    }

    public static void writeLengthEncodedString(ByteBuf buffer, String value, Charset charset) {
        byte[] bytes = value.getBytes(charset);
        BufferUtils.writeLengthEncodedInteger(buffer, bytes.length);
        buffer.writeBytes(bytes);
    }

    public static String readLengthEncodedString(ByteBuf buffer, Charset charset) {
        long length = BufferUtils.readLengthEncodedInteger(buffer);
        return BufferUtils.readFixedLengthString(buffer, (int)length, charset);
    }
}

