/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.ext.web.openapi.Operation;
import io.vertx.ext.web.openapi.RouterBuilderException;
import io.vertx.ext.web.openapi.RouterBuilderOptions;
import io.vertx.ext.web.openapi.SecurityScheme;
import io.vertx.ext.web.openapi.impl.OpenAPI3RouterBuilderImpl;
import io.vertx.ext.web.openapi.impl.OpenAPIHolderImpl;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.ValidationException;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface RouterBuilder {
    public @Nullable Operation operation(String var1);

    public List<Operation> operations();

    @Fluent
    public RouterBuilder bodyHandler(@Nullable BodyHandler var1);

    @Fluent
    public RouterBuilder rootHandler(Handler<RoutingContext> var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public RouterBuilder securityHandler(String var1, AuthenticationHandler var2);

    @Fluent
    public RouterBuilder mountServicesFromExtensions();

    @Fluent
    @GenIgnore
    public RouterBuilder mountServiceInterface(Class var1, String var2);

    @Fluent
    public RouterBuilder setOptions(RouterBuilderOptions var1);

    public RouterBuilderOptions getOptions();

    public OpenAPIHolder getOpenAPI();

    @Deprecated
    public SchemaRouter getSchemaRouter();

    @Deprecated
    public SchemaParser getSchemaParser();

    @Fluent
    public RouterBuilder serviceExtraPayloadMapper(Function<RoutingContext, JsonObject> var1);

    public SecurityScheme securityHandler(String var1);

    public Router createRouter();

    public static Future<RouterBuilder> create(Vertx vertx, String url) {
        return RouterBuilder.create(vertx, url, new OpenAPILoaderOptions());
    }

    public static void create(Vertx vertx, String url, Handler<AsyncResult<RouterBuilder>> handler) {
        RouterBuilder.create(vertx, url).onComplete(handler);
    }

    public static Future<RouterBuilder> create(Vertx vertx, String url, OpenAPILoaderOptions options) {
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        HttpClient httpClient = vertx.createHttpClient();
        OpenAPIHolderImpl loader = new OpenAPIHolderImpl(vertx, httpClient, vertx.fileSystem(), options);
        loader.loadOpenAPI(url).onComplete(arg_0 -> RouterBuilder.lambda$create$0((Promise)promise, url, vertx, httpClient, loader, options, arg_0));
        return promise.future();
    }

    public static void create(Vertx vertx, String url, OpenAPILoaderOptions options, Handler<AsyncResult<RouterBuilder>> handler) {
        RouterBuilder.create(vertx, url, options).onComplete(handler);
    }

    private static /* synthetic */ void lambda$create$0(Promise promise, String url, Vertx vertx, HttpClient httpClient, OpenAPIHolderImpl loader, OpenAPILoaderOptions options, AsyncResult ar) {
        if (ar.failed()) {
            if (ar.cause() instanceof ValidationException) {
                promise.fail((Throwable)RouterBuilderException.createInvalidSpec(ar.cause()));
            } else {
                promise.fail((Throwable)RouterBuilderException.createInvalidSpecFile(url, ar.cause()));
            }
        } else {
            OpenAPI3RouterBuilderImpl factory;
            try {
                factory = new OpenAPI3RouterBuilderImpl(vertx, httpClient, loader, options);
            }
            catch (Exception e) {
                promise.fail((Throwable)RouterBuilderException.createRouterBuilderInstantiationError(e, url));
                return;
            }
            promise.complete((Object)factory);
        }
    }
}

