/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.NetworkChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.closeable.CloseableUtils;

public abstract class Nio2Service
extends AbstractInnerCloseable
implements IoService,
FactoryManagerHolder {
    protected final Map<Long, IoSession> sessions;
    protected final AtomicBoolean disposing = new AtomicBoolean();
    private final FactoryManager manager;
    private final IoHandler handler;
    private final AsynchronousChannelGroup group;

    protected Nio2Service(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating {}", (Object)this.getClass().getSimpleName());
        }
        this.manager = ValidateUtils.checkNotNull(manager, "No factory manager provided");
        this.handler = ValidateUtils.checkNotNull(handler, "No I/O handler provided");
        this.group = ValidateUtils.checkNotNull(group, "No async. channel group provided");
        this.sessions = new ConcurrentHashMap<Long, IoSession>();
    }

    protected AsynchronousChannelGroup getChannelGroup() {
        return this.group;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.manager;
    }

    public IoHandler getIoHandler() {
        return this.handler;
    }

    public void dispose() {
        block4: {
            try {
                long maxWait = CloseableUtils.getMaxCloseWaitTime(this.getFactoryManager());
                boolean successful = this.close(true).await(maxWait);
                if (!successful) {
                    throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(e.getClass().getSimpleName() + " while stopping service: " + e.getMessage());
                }
                if (!this.log.isTraceEnabled()) break block4;
                this.log.trace("Stop exception details", (Throwable)e);
            }
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.sessions.values()).build();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public void sessionClosed(Nio2Session session) {
        this.sessions.remove(session.getId());
    }

    protected <T> void setOption(NetworkChannel socket, String property, SocketOption<T> option, T defaultValue) throws IOException {
        FactoryManager manager = this.getFactoryManager();
        String valStr = PropertyResolverUtils.getString(manager, property);
        T val = defaultValue;
        if (!GenericUtils.isEmpty(valStr)) {
            Class<T> type = option.type();
            if (type == Integer.class) {
                val = type.cast(Integer.valueOf(valStr));
            } else if (type == Boolean.class) {
                val = type.cast(Boolean.valueOf(valStr));
            } else {
                throw new IllegalStateException("Unsupported socket option type " + type);
            }
        }
        if (val != null) {
            Set<SocketOption<?>> supported = socket.supportedOptions();
            if (GenericUtils.size(supported) <= 0 || !supported.contains(option)) {
                this.log.warn("Unsupported socket option (" + option + ") to set using property '" + property + "' value=" + val);
                return;
            }
            try {
                socket.setOption(option, val);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("setOption({})[{}] from property={}", new Object[]{option, val, property});
                }
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("Unable (" + e.getClass().getSimpleName() + ")" + " to set socket option " + option + " using property '" + property + "' value=" + val + ": " + e.getMessage());
            }
        }
    }
}

