/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;

public interface ServerAuthenticationManager {
    public static final String MAX_AUTH_REQUESTS = "max-auth-requests";
    public static final int DEFAULT_MAX_AUTH_REQUESTS = 20;

    public List<NamedFactory<UserAuth>> getUserAuthFactories();

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> var1);

    public PublickeyAuthenticator getPublickeyAuthenticator();

    public void setPasswordAuthenticator(PasswordAuthenticator var1);

    public PasswordAuthenticator getPasswordAuthenticator();

    public void setPublickeyAuthenticator(PublickeyAuthenticator var1);

    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator();

    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator var1);

    public GSSAuthenticator getGSSAuthenticator();

    public void setGSSAuthenticator(GSSAuthenticator var1);

    public HostBasedAuthenticator getHostBasedAuthenticator();

    public void setHostBasedAuthenticator(HostBasedAuthenticator var1);

    public static final class Utils {
        public static final UserAuthPublicKeyFactory DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY = UserAuthPublicKeyFactory.INSTANCE;
        public static final UserAuthGSSFactory DEFAULT_USER_AUTH_GSS_FACTORY = UserAuthGSSFactory.INSTANCE;
        public static final UserAuthPasswordFactory DEFAULT_USER_AUTH_PASSWORD_FACTORY = UserAuthPasswordFactory.INSTANCE;
        public static final UserAuthKeyboardInteractiveFactory DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY = UserAuthKeyboardInteractiveFactory.INSTANCE;

        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static List<NamedFactory<UserAuth>> resolveUserAuthFactories(ServerAuthenticationManager manager) {
            if (manager == null) {
                return Collections.emptyList();
            }
            return Utils.resolveUserAuthFactories(manager, manager.getUserAuthFactories());
        }

        public static List<NamedFactory<UserAuth>> resolveUserAuthFactories(ServerAuthenticationManager manager, List<NamedFactory<UserAuth>> userFactories) {
            if (GenericUtils.size(userFactories) > 0) {
                return userFactories;
            }
            if (manager == null) {
                return Collections.emptyList();
            }
            ArrayList<NamedFactory<UserAuth>> factories = new ArrayList<NamedFactory<UserAuth>>();
            if (manager.getPasswordAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_PASSWORD_FACTORY);
                factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
            } else if (manager.getKeyboardInteractiveAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
            }
            if (manager.getPublickeyAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
            }
            if (manager.getGSSAuthenticator() != null) {
                factories.add(DEFAULT_USER_AUTH_GSS_FACTORY);
            }
            return factories;
        }
    }
}

