/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.amqp;

import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.amqp.AmqpConnection;
import io.vertx.rxjava.amqp.AmqpReceiver;
import io.vertx.rxjava.amqp.AmqpSender;
import rx.Single;

@RxGen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    public AmqpClient(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpClient)delegate;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.rxjava.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    public AmqpClient connect(final Handler<AsyncResult<AmqpConnection>> connectionHandler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
                if (ar.succeeded()) {
                    connectionHandler.handle((Object)Future.succeededFuture((Object)AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
                } else {
                    connectionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpClient connect() {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)ar -> {}));
    }

    public Single<AmqpConnection> rxConnect() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<AmqpConnection>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public AmqpClient createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpClient createReceiver(String address) {
        return this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)fut)));
    }

    public AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)fut)));
    }

    public AmqpClient createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpClient createSender(String address) {
        return this.createSender(address, (Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createSender(address, (Handler<AsyncResult<AmqpSender>>)fut)));
    }

    public AmqpClient createSender(String address, AmqpSenderOptions options, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpClient createSender(String address, AmqpSenderOptions options) {
        return this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)fut)));
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

