/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.Cookie;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg(obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private static final TypeArg<Cookie> TYPE_ARG_0 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Cookie> TYPE_ARG_1 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private MultiMap cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
    }

    public void write(String chunk, String enc) {
        this.write(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxWrite(String chunk, String enc) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
    }

    @Override
    public void write(String chunk) {
        this.write(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(String chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse writeContinue() {
        this.delegate.writeContinue();
        return this;
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    @Override
    public void end(String chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(String chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    public void end(String chunk, String enc) {
        this.end(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxEnd(String chunk, String enc) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(Handler<AsyncResult<Void>> handler) {
        this.delegate.send(handler);
    }

    public void send() {
        this.send((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send((Handler<AsyncResult<Void>>)fut)));
    }

    public void send(String body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(body, handler);
    }

    public void send(String body) {
        this.send(body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(String body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(body.getDelegate(), handler);
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body) {
        this.send(body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(io.vertx.rxjava.core.buffer.Buffer body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(body.getDelegate(), handler);
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), handler);
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public HttpServerResponse sendFile(String filename) {
        return this.sendFile(filename, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSendFile(String filename) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public HttpServerResponse sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSendFile(String filename, long offset) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public HttpServerResponse sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSendFile(String filename, long offset, long length) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, host, path, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path) {
        return this.push(method, host, path, (Handler<AsyncResult<HttpServerResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.push(method, host, path, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, path, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers) {
        return this.push(method, path, headers, (Handler<AsyncResult<HttpServerResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path, MultiMap headers) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.push(method, path, headers, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String path, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, path, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String path) {
        return this.push(method, path, (Handler<AsyncResult<HttpServerResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.push(method, path, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, host, path, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers) {
        return this.push(method, host, path, headers, (Handler<AsyncResult<HttpServerResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path, MultiMap headers) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.push(method, host, path, headers, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpServerResponse writeCustomFrame(int type, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie.getDelegate());
        return this;
    }

    public Cookie removeCookie(String name) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name));
        return ret;
    }

    public Cookie removeCookie(String name, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, invalidate));
        return ret;
    }

    public Set<Cookie> removeCookies(String name) {
        Set<Cookie> ret = this.delegate.removeCookies(name).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Set<Cookie> removeCookies(String name, boolean invalidate) {
        Set<Cookie> ret = this.delegate.removeCookies(name, invalidate).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, domain, path));
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, domain, path, invalidate));
        return ret;
    }

    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        this.delegate.putTrailer(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

