/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.WebSocketBase;
import io.vertx.rxjava.core.http.WebSocketFrame;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import javax.net.ssl.SSLSession;
import rx.Observable;
import rx.Single;

class WebSocketBaseImpl
implements WebSocketBase {
    private final io.vertx.core.http.WebSocketBase delegate;
    private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
        this.delegate = delegate;
    }

    public WebSocketBaseImpl(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketBase)delegate;
    }

    @Override
    public io.vertx.core.http.WebSocketBase getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
            this.observable = RxHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer data) {
        this.end(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxPipeTo(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase handler(final Handler<io.vertx.rxjava.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocketBase resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocketBase fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public WebSocketBase endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocketBase setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocketBase drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public WebSocketBase writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writeFrame(WebSocketFrame frame) {
        return this.writeFrame(frame, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWriteFrame(WebSocketFrame frame) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writeFrame(frame, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, handler);
        return this;
    }

    @Override
    public WebSocketBase writeFinalTextFrame(String text) {
        return this.writeFinalTextFrame(text, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWriteFinalTextFrame(String text) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writeFinalTextFrame(text, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data) {
        return this.writeFinalBinaryFrame(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWriteFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writeFinalBinaryFrame(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data) {
        return this.writeBinaryMessage(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWriteBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writeBinaryMessage(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, handler);
        return this;
    }

    @Override
    public WebSocketBase writeTextMessage(String text) {
        return this.writeTextMessage(text, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWriteTextMessage(String text) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writeTextMessage(text, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writePing(data.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data) {
        return this.writePing(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWritePing(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writePing(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writePong(data.getDelegate(), handler);
        return this;
    }

    @Override
    public WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data) {
        return this.writePong(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWritePong(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.writePong(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public WebSocketBase closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle((Object)WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(final Handler<io.vertx.rxjava.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(final Handler<io.vertx.rxjava.core.buffer.Buffer> handler) {
        this.delegate.pongHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    @Override
    public void close(short statusCode) {
        this.close(statusCode, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxClose(short statusCode) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close(statusCode, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    @Override
    public void close(short statusCode, String reason) {
        this.close(statusCode, reason, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxClose(short statusCode, String reason) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close(statusCode, reason, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }
}

